package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A messaging resource that allows you to configure High Availability for the
 * ActiveMQ server (the value of ha-policy can be live-only, replication-master,
 * replication-slave, or replication-colocated).
 */
@Address("/subsystem=messaging-activemq/server=*/ha-policy=shared-store-master")
@ResourceType("ha-policy")
@Implicit
public class SharedStoreMasterHAPolicy<T extends SharedStoreMasterHAPolicy<T>>
		extends
			HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean failoverOnServerShutdown;

	public SharedStoreMasterHAPolicy() {
		super();
		this.key = "shared-store-master";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Whether the server must failover when it is normally shutdown.
	 */
	@ModelNodeBinding(detypedName = "failover-on-server-shutdown")
	public Boolean failoverOnServerShutdown() {
		return this.failoverOnServerShutdown;
	}

	/**
	 * Whether the server must failover when it is normally shutdown.
	 */
	@SuppressWarnings("unchecked")
	public T failoverOnServerShutdown(Boolean value) {
		Object oldValue = this.failoverOnServerShutdown;
		this.failoverOnServerShutdown = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("failoverOnServerShutdown", oldValue,
					value);
		return (T) this;
	}
}