package org.wildfly.swarm.config.naming;

import org.wildfly.swarm.config.naming.RemoteNamingService;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface RemoteNamingServiceConsumer<T extends RemoteNamingService<T>> {

	/**
	 * Configure a pre-constructed instance of RemoteNamingService resource
	 * 
	 * @parameter Instance of RemoteNamingService to configure
	 * @return nothing
	 */
	void accept(T value);

	default RemoteNamingServiceConsumer<T> andThen(
			RemoteNamingServiceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}