package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.undertow.configuration.ErrorPage;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ErrorPageConsumer<T extends ErrorPage<T>> {

	/**
	 * Configure a pre-constructed instance of ErrorPage resource
	 * 
	 * @parameter Instance of ErrorPage to configure
	 * @return nothing
	 */
	void accept(T value);

	default ErrorPageConsumer<T> andThen(ErrorPageConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}