package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A rewrite (or redirect) filter
 */
@Address("/subsystem=undertow/configuration=filter/rewrite=*")
@ResourceType("rewrite")
public class Rewrite<T extends Rewrite<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean redirect;
	private String target;

	public Rewrite(String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * If this is true then a redirect will be done instead of a rewrite
	 */
	@ModelNodeBinding(detypedName = "redirect")
	public Boolean redirect() {
		return this.redirect;
	}

	/**
	 * If this is true then a redirect will be done instead of a rewrite
	 */
	@SuppressWarnings("unchecked")
	public T redirect(Boolean value) {
		Object oldValue = this.redirect;
		this.redirect = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("redirect", oldValue, value);
		return (T) this;
	}

	/**
	 * The expression that defines the target. If you are redirecting to a
	 * constant target put single quotes around the value
	 */
	@ModelNodeBinding(detypedName = "target")
	public String target() {
		return this.target;
	}

	/**
	 * The expression that defines the target. If you are redirecting to a
	 * constant target put single quotes around the value
	 */
	@SuppressWarnings("unchecked")
	public T target(String value) {
		Object oldValue = this.target;
		this.target = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("target", oldValue, value);
		return (T) this;
	}
}