package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.undertow.servlet_container.CrawlerSessionManagementSetting;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface CrawlerSessionManagementSettingConsumer<T extends CrawlerSessionManagementSetting<T>> {

	/**
	 * Configure a pre-constructed instance of CrawlerSessionManagementSetting
	 * resource
	 * 
	 * @parameter Instance of CrawlerSessionManagementSetting to configure
	 * @return nothing
	 */
	void accept(T value);

	default CrawlerSessionManagementSettingConsumer<T> andThen(
			CrawlerSessionManagementSettingConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}