/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.mail.MailSession;
import org.wildfly.swarm.config.mail.MailSessionConsumer;
import org.wildfly.swarm.config.mail.MailSessionSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=mail")
@ResourceType(value="subsystem")
@Implicit
public class Mail<T extends Mail<T>>
extends HashMap {
    private String key = "mail";
    private PropertyChangeSupport pcs;
    private MailResources subresources = new MailResources();

    public Mail() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public MailResources subresources() {
        return this.subresources;
    }

    public T mailSessions(List<MailSession> value) {
        this.subresources.mailSessions = value;
        return (T)this;
    }

    public T mailSession(MailSession value) {
        this.subresources.mailSessions.add(value);
        return (T)this;
    }

    public T mailSession(String childKey, MailSessionConsumer consumer) {
        MailSession child = new MailSession(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.mailSession(child);
        return (T)this;
    }

    public T mailSession(String childKey) {
        this.mailSession(childKey, null);
        return (T)this;
    }

    public T mailSession(MailSessionSupplier supplier) {
        this.mailSession(supplier.get());
        return (T)this;
    }

    public static class MailResources {
        private List<MailSession> mailSessions = new ArrayList<MailSession>();

        @Subresource
        public List<MailSession> mailSessions() {
            return this.mailSessions;
        }

        public MailSession mailSession(String key) {
            return this.mailSessions.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

