/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.access;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.management.access.logger.Handler;
import org.wildfly.swarm.config.management.access.logger.HandlerConsumer;
import org.wildfly.swarm.config.management.access.logger.HandlerSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/core-service=management/access=audit/logger=audit-log")
@ResourceType(value="logger")
@Implicit
public class AuditLogLogger<T extends AuditLogLogger<T>>
extends HashMap {
    private String key = "audit-log";
    private PropertyChangeSupport pcs;
    private AuditLogLoggerResources subresources = new AuditLogLoggerResources();
    private Boolean enabled;
    private Boolean logBoot;
    private Boolean logReadOnly;

    public AuditLogLogger() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public AuditLogLoggerResources subresources() {
        return this.subresources;
    }

    public T handlers(List<Handler> value) {
        this.subresources.handlers = value;
        return (T)this;
    }

    public T handler(Handler value) {
        this.subresources.handlers.add(value);
        return (T)this;
    }

    public T handler(String childKey, HandlerConsumer consumer) {
        Handler child = new Handler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.handler(child);
        return (T)this;
    }

    public T handler(String childKey) {
        this.handler(childKey, null);
        return (T)this;
    }

    public T handler(HandlerSupplier supplier) {
        this.handler(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enabled")
    public Boolean enabled() {
        return this.enabled;
    }

    public T enabled(Boolean value) {
        Boolean oldValue = this.enabled;
        this.enabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="log-boot")
    public Boolean logBoot() {
        return this.logBoot;
    }

    public T logBoot(Boolean value) {
        Boolean oldValue = this.logBoot;
        this.logBoot = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("logBoot", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="log-read-only")
    public Boolean logReadOnly() {
        return this.logReadOnly;
    }

    public T logReadOnly(Boolean value) {
        Boolean oldValue = this.logReadOnly;
        this.logReadOnly = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("logReadOnly", oldValue, value);
        }
        return (T)this;
    }

    public static class AuditLogLoggerResources {
        private List<Handler> handlers = new ArrayList<Handler>();

        @Subresource
        public List<Handler> handlers() {
            return this.handlers;
        }

        public Handler handler(String key) {
            return this.handlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

