/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.security_realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCache;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheSupplier;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCache;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/core-service=management/security-realm=*/authentication=ldap")
@ResourceType(value="authentication")
@Implicit
public class LdapAuthentication<T extends LdapAuthentication<T>>
extends HashMap {
    private String key = "ldap";
    private PropertyChangeSupport pcs;
    private LdapAuthenticationResources subresources = new LdapAuthenticationResources();
    private String advancedFilter;
    private Boolean allowEmptyPasswords;
    private String baseDn;
    private String connection;
    private Boolean recursive;
    private String userDn;
    private String usernameAttribute;
    private String usernameLoad;

    public LdapAuthentication() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public LdapAuthenticationResources subresources() {
        return this.subresources;
    }

    public T bySearchTimeCache(BySearchTimeCache value) {
        this.subresources.bySearchTimeCache = value;
        return (T)this;
    }

    public T bySearchTimeCache(BySearchTimeCacheConsumer consumer) {
        BySearchTimeCache child = new BySearchTimeCache();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.bySearchTimeCache = child;
        return (T)this;
    }

    public T bySearchTimeCache() {
        BySearchTimeCache child = new BySearchTimeCache();
        this.subresources.bySearchTimeCache = child;
        return (T)this;
    }

    public T bySearchTimeCache(BySearchTimeCacheSupplier supplier) {
        this.subresources.bySearchTimeCache = supplier.get();
        return (T)this;
    }

    public T byAccessTimeCache(ByAccessTimeCache value) {
        this.subresources.byAccessTimeCache = value;
        return (T)this;
    }

    public T byAccessTimeCache(ByAccessTimeCacheConsumer consumer) {
        ByAccessTimeCache child = new ByAccessTimeCache();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.byAccessTimeCache = child;
        return (T)this;
    }

    public T byAccessTimeCache() {
        ByAccessTimeCache child = new ByAccessTimeCache();
        this.subresources.byAccessTimeCache = child;
        return (T)this;
    }

    public T byAccessTimeCache(ByAccessTimeCacheSupplier supplier) {
        this.subresources.byAccessTimeCache = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advanced-filter")
    public String advancedFilter() {
        return this.advancedFilter;
    }

    public T advancedFilter(String value) {
        String oldValue = this.advancedFilter;
        this.advancedFilter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("advancedFilter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allow-empty-passwords")
    public Boolean allowEmptyPasswords() {
        return this.allowEmptyPasswords;
    }

    public T allowEmptyPasswords(Boolean value) {
        Boolean oldValue = this.allowEmptyPasswords;
        this.allowEmptyPasswords = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowEmptyPasswords", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="base-dn")
    public String baseDn() {
        return this.baseDn;
    }

    public T baseDn(String value) {
        String oldValue = this.baseDn;
        this.baseDn = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("baseDn", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection")
    public String connection() {
        return this.connection;
    }

    public T connection(String value) {
        String oldValue = this.connection;
        this.connection = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connection", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recursive")
    public Boolean recursive() {
        return this.recursive;
    }

    public T recursive(Boolean value) {
        Boolean oldValue = this.recursive;
        this.recursive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recursive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="user-dn")
    public String userDn() {
        return this.userDn;
    }

    public T userDn(String value) {
        String oldValue = this.userDn;
        this.userDn = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("userDn", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="username-attribute")
    public String usernameAttribute() {
        return this.usernameAttribute;
    }

    public T usernameAttribute(String value) {
        String oldValue = this.usernameAttribute;
        this.usernameAttribute = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("usernameAttribute", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="username-load")
    public String usernameLoad() {
        return this.usernameLoad;
    }

    public T usernameLoad(String value) {
        String oldValue = this.usernameLoad;
        this.usernameLoad = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("usernameLoad", oldValue, value);
        }
        return (T)this;
    }

    public static class LdapAuthenticationResources {
        private BySearchTimeCache bySearchTimeCache;
        private ByAccessTimeCache byAccessTimeCache;

        @Subresource
        public BySearchTimeCache bySearchTimeCache() {
            return this.bySearchTimeCache;
        }

        @Subresource
        public ByAccessTimeCache byAccessTimeCache() {
            return this.byAccessTimeCache;
        }
    }
}

