package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Defines a thread pool used for asynchronous transport communication.
 */
@Address("/subsystem=infinispan/cache-container=*/thread-pool=transport")
@ResourceType("thread-pool")
@Implicit
public class TransportThreadPool<T extends TransportThreadPool<T>>
		extends
			HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Long keepaliveTime;
	private Integer maxThreads;
	private Integer minThreads;
	private Integer queueLength;

	public TransportThreadPool() {
		super();
		this.key = "transport";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be
	 * kept running when idle; if not specified, threads will run until the
	 * executor is shut down.
	 */
	@ModelNodeBinding(detypedName = "keepalive-time")
	public Long keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be
	 * kept running when idle; if not specified, threads will run until the
	 * executor is shut down.
	 */
	@SuppressWarnings("unchecked")
	public T keepaliveTime(java.lang.Long value) {
		Object oldValue = this.keepaliveTime;
		this.keepaliveTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keepaliveTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public T maxThreads(java.lang.Integer value) {
		Object oldValue = this.maxThreads;
		this.maxThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxThreads", oldValue, value);
		return (T) this;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If
	 * undefined, the core thread pool size is the same as the maximum thread
	 * pool size.
	 */
	@ModelNodeBinding(detypedName = "min-threads")
	public Integer minThreads() {
		return this.minThreads;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If
	 * undefined, the core thread pool size is the same as the maximum thread
	 * pool size.
	 */
	@SuppressWarnings("unchecked")
	public T minThreads(java.lang.Integer value) {
		Object oldValue = this.minThreads;
		this.minThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minThreads", oldValue, value);
		return (T) this;
	}

	/**
	 * The queue length.
	 */
	@ModelNodeBinding(detypedName = "queue-length")
	public Integer queueLength() {
		return this.queueLength;
	}

	/**
	 * The queue length.
	 */
	@SuppressWarnings("unchecked")
	public T queueLength(java.lang.Integer value) {
		Object oldValue = this.queueLength;
		this.queueLength = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queueLength", oldValue, value);
		return (T) this;
	}
}