package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Cached connection manager for resource adapters
 */
@Address("/subsystem=jca/cached-connection-manager=cached-connection-manager")
@ResourceType("cached-connection-manager")
@Implicit
public class CachedConnectionManager<T extends CachedConnectionManager<T>>
		extends
			HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean debug;
	private Boolean error;
	private Boolean ignoreUnknownConnections;
	private Boolean install;

	public CachedConnectionManager() {
		super();
		this.key = "cached-connection-manager";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Enable/disable debug information logging
	 */
	@ModelNodeBinding(detypedName = "debug")
	public Boolean debug() {
		return this.debug;
	}

	/**
	 * Enable/disable debug information logging
	 */
	@SuppressWarnings("unchecked")
	public T debug(java.lang.Boolean value) {
		Object oldValue = this.debug;
		this.debug = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("debug", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable/disable error information logging
	 */
	@ModelNodeBinding(detypedName = "error")
	public Boolean error() {
		return this.error;
	}

	/**
	 * Enable/disable error information logging
	 */
	@SuppressWarnings("unchecked")
	public T error(java.lang.Boolean value) {
		Object oldValue = this.error;
		this.error = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("error", oldValue, value);
		return (T) this;
	}

	/**
	 * Do not cache unknown connections
	 */
	@ModelNodeBinding(detypedName = "ignore-unknown-connections")
	public Boolean ignoreUnknownConnections() {
		return this.ignoreUnknownConnections;
	}

	/**
	 * Do not cache unknown connections
	 */
	@SuppressWarnings("unchecked")
	public T ignoreUnknownConnections(java.lang.Boolean value) {
		Object oldValue = this.ignoreUnknownConnections;
		this.ignoreUnknownConnections = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ignoreUnknownConnections", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Enable/disable the cached connection manager valve and interceptor
	 */
	@ModelNodeBinding(detypedName = "install")
	public Boolean install() {
		return this.install;
	}

	/**
	 * Enable/disable the cached connection manager valve and interceptor
	 */
	@SuppressWarnings("unchecked")
	public T install(java.lang.Boolean value) {
		Object oldValue = this.install;
		this.install = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("install", oldValue, value);
		return (T) this;
	}
}