package org.wildfly.swarm.config.undertow.server.host;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.server.host.FilterRefConsumer;
import org.wildfly.swarm.config.undertow.server.host.FilterRefSupplier;
import org.wildfly.swarm.config.undertow.server.host.FilterRef;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Holds configuration of location resource
 */
@Address("/subsystem=undertow/server=*/host=*/location=*")
@ResourceType("location")
public class Location<T extends Location<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private LocationResources subresources = new LocationResources();
	private String handler;

	public Location(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public LocationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all FilterRef objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of FilterRef objects.
	 */
	@SuppressWarnings("unchecked")
	public T filterRefs(java.util.List<FilterRef> value) {
		this.subresources.filterRefs = value;
		return (T) this;
	}

	/**
	 * Add the FilterRef object to the list of subresources
	 * 
	 * @param value
	 *            The FilterRef to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filterRef(FilterRef value) {
		this.subresources.filterRefs.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a FilterRef object to the list of subresources
	 * 
	 * @param key
	 *            The key for the FilterRef resource
	 * @param config
	 *            The FilterRefConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filterRef(java.lang.String childKey, FilterRefConsumer consumer) {
		FilterRef<? extends FilterRef> child = new FilterRef<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		filterRef(child);
		return (T) this;
	}

	/**
	 * Create and configure a FilterRef object to the list of subresources
	 * 
	 * @param key
	 *            The key for the FilterRef resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filterRef(java.lang.String childKey) {
		filterRef(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied FilterRef object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T filterRef(FilterRefSupplier supplier) {
		filterRef(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Location
	 */
	public static class LocationResources {
		/**
		 * Reference to filter
		 */
		private List<FilterRef> filterRefs = new java.util.ArrayList<>();

		/**
		 * Get the list of FilterRef resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<FilterRef> filterRefs() {
			return this.filterRefs;
		}

		public FilterRef filterRef(java.lang.String key) {
			return this.filterRefs.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}

	/**
	 * Default handler for this location
	 */
	@ModelNodeBinding(detypedName = "handler")
	public String handler() {
		return this.handler;
	}

	/**
	 * Default handler for this location
	 */
	@SuppressWarnings("unchecked")
	public T handler(java.lang.String value) {
		Object oldValue = this.handler;
		this.handler = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("handler", oldValue, value);
		return (T) this;
	}
}