/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.jgroups.Channel;
import org.wildfly.swarm.config.jgroups.ChannelConsumer;
import org.wildfly.swarm.config.jgroups.ChannelSupplier;
import org.wildfly.swarm.config.jgroups.Stack;
import org.wildfly.swarm.config.jgroups.StackConsumer;
import org.wildfly.swarm.config.jgroups.StackSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=jgroups")
@ResourceType(value="subsystem")
@Implicit
public class JGroups<T extends JGroups<T>>
extends HashMap {
    private String key = "jgroups";
    private PropertyChangeSupport pcs;
    private JGroupsResources subresources = new JGroupsResources();
    private String defaultChannel;

    public JGroups() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public JGroupsResources subresources() {
        return this.subresources;
    }

    public T stacks(List<Stack> value) {
        this.subresources.stacks = value;
        return (T)this;
    }

    public T stack(Stack value) {
        this.subresources.stacks.add(value);
        return (T)this;
    }

    public T stack(String childKey, StackConsumer consumer) {
        Stack child = new Stack(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.stack(child);
        return (T)this;
    }

    public T stack(String childKey) {
        this.stack(childKey, null);
        return (T)this;
    }

    public T stack(StackSupplier supplier) {
        this.stack(supplier.get());
        return (T)this;
    }

    public T channels(List<Channel> value) {
        this.subresources.channels = value;
        return (T)this;
    }

    public T channel(Channel value) {
        this.subresources.channels.add(value);
        return (T)this;
    }

    public T channel(String childKey, ChannelConsumer consumer) {
        Channel child = new Channel(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.channel(child);
        return (T)this;
    }

    public T channel(String childKey) {
        this.channel(childKey, null);
        return (T)this;
    }

    public T channel(ChannelSupplier supplier) {
        this.channel(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-channel")
    public String defaultChannel() {
        return this.defaultChannel;
    }

    public T defaultChannel(String value) {
        String oldValue = this.defaultChannel;
        this.defaultChannel = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultChannel", oldValue, value);
        }
        return (T)this;
    }

    public static class JGroupsResources {
        private List<Stack> stacks = new ArrayList<Stack>();
        private List<Channel> channels = new ArrayList<Channel>();

        @Subresource
        public List<Stack> stacks() {
            return this.stacks;
        }

        public Stack stack(String key) {
            return this.stacks.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Channel> channels() {
            return this.channels;
        }

        public Channel channel(String key) {
            return this.channels.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

