package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.manager.DefaultDeploymentPermissions;
import org.wildfly.swarm.config.security.manager.DefaultDeploymentPermissionsConsumer;
import org.wildfly.swarm.config.security.manager.DefaultDeploymentPermissionsSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Security Manager subsystem
 */
@Address("/subsystem=security-manager")
@ResourceType("subsystem")
@Implicit
public class SecurityManager<T extends SecurityManager<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private SecurityManagerResources subresources = new SecurityManagerResources();

	public SecurityManager() {
		super();
		this.key = "security-manager";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public SecurityManagerResources subresources() {
		return this.subresources;
	}

	/**
	 * The permissions that are to be granted to deployments
	 */
	@SuppressWarnings("unchecked")
	public T defaultDeploymentPermissions(DefaultDeploymentPermissions value) {
		this.subresources.defaultDeploymentPermissions = value;
		return (T) this;
	}

	/**
	 * The permissions that are to be granted to deployments
	 */
	@SuppressWarnings("unchecked")
	public T defaultDeploymentPermissions(
			DefaultDeploymentPermissionsConsumer consumer) {
		DefaultDeploymentPermissions<? extends DefaultDeploymentPermissions> child = new DefaultDeploymentPermissions<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.defaultDeploymentPermissions = child;
		return (T) this;
	}

	/**
	 * The permissions that are to be granted to deployments
	 */
	@SuppressWarnings("unchecked")
	public T defaultDeploymentPermissions() {
		DefaultDeploymentPermissions<? extends DefaultDeploymentPermissions> child = new DefaultDeploymentPermissions<>();
		this.subresources.defaultDeploymentPermissions = child;
		return (T) this;
	}

	/**
	 * The permissions that are to be granted to deployments
	 */
	@SuppressWarnings("unchecked")
	public T defaultDeploymentPermissions(
			DefaultDeploymentPermissionsSupplier supplier) {
		this.subresources.defaultDeploymentPermissions = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for SecurityManager
	 */
	public static class SecurityManagerResources {
		private DefaultDeploymentPermissions defaultDeploymentPermissions;

		/**
		 * The permissions that are to be granted to deployments
		 */
		@Subresource
		public DefaultDeploymentPermissions defaultDeploymentPermissions() {
			return this.defaultDeploymentPermissions;
		}
	}
}