package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Addresses;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * The locking configuration of the cache.
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/component=locking",
		"/subsystem=infinispan/cache-container=*/local-cache=*/component=locking",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/component=locking",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/component=locking"})
@ResourceType("component")
@Implicit
public class LockingComponent<T extends LockingComponent<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Long acquireTimeout;
	private Integer concurrencyLevel;
	private Integer currentConcurrencyLevel;
	private Isolation isolation;
	private Integer numberOfLocksAvailable;
	private Integer numberOfLocksHeld;
	private Boolean striping;

	public LockingComponent() {
		super();
		this.key = "locking";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum Isolation {
		NONE("NONE"), SERIALIZABLE("SERIALIZABLE"), REPEATABLE_READ(
				"REPEATABLE_READ"), READ_COMMITTED("READ_COMMITTED"), READ_UNCOMMITTED(
				"READ_UNCOMMITTED");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Isolation(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * Maximum time to attempt a particular lock acquisition.
	 */
	@ModelNodeBinding(detypedName = "acquire-timeout")
	public Long acquireTimeout() {
		return this.acquireTimeout;
	}

	/**
	 * Maximum time to attempt a particular lock acquisition.
	 */
	@SuppressWarnings("unchecked")
	public T acquireTimeout(java.lang.Long value) {
		Object oldValue = this.acquireTimeout;
		this.acquireTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("acquireTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Concurrency level for lock containers. Adjust this value according to the
	 * number of concurrent threads interacting with Infinispan.
	 */
	@ModelNodeBinding(detypedName = "concurrency-level")
	public Integer concurrencyLevel() {
		return this.concurrencyLevel;
	}

	/**
	 * Concurrency level for lock containers. Adjust this value according to the
	 * number of concurrent threads interacting with Infinispan.
	 */
	@SuppressWarnings("unchecked")
	public T concurrencyLevel(java.lang.Integer value) {
		Object oldValue = this.concurrencyLevel;
		this.concurrencyLevel = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("concurrencyLevel", oldValue, value);
		return (T) this;
	}

	/**
	 * The estimated number of concurrently updating threads which this cache
	 * can support. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "current-concurrency-level")
	public Integer currentConcurrencyLevel() {
		return this.currentConcurrencyLevel;
	}

	/**
	 * The estimated number of concurrently updating threads which this cache
	 * can support. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T currentConcurrencyLevel(java.lang.Integer value) {
		Object oldValue = this.currentConcurrencyLevel;
		this.currentConcurrencyLevel = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("currentConcurrencyLevel", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Sets the cache locking isolation level.
	 */
	@ModelNodeBinding(detypedName = "isolation")
	public Isolation isolation() {
		return this.isolation;
	}

	/**
	 * Sets the cache locking isolation level.
	 */
	@SuppressWarnings("unchecked")
	public T isolation(Isolation value) {
		Object oldValue = this.isolation;
		this.isolation = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("isolation", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of locks available to this cache. May return null if the cache
	 * is not started.
	 */
	@ModelNodeBinding(detypedName = "number-of-locks-available")
	public Integer numberOfLocksAvailable() {
		return this.numberOfLocksAvailable;
	}

	/**
	 * The number of locks available to this cache. May return null if the cache
	 * is not started.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfLocksAvailable(java.lang.Integer value) {
		Object oldValue = this.numberOfLocksAvailable;
		this.numberOfLocksAvailable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfLocksAvailable", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of locks currently in use by this cache. May return null if
	 * the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "number-of-locks-held")
	public Integer numberOfLocksHeld() {
		return this.numberOfLocksHeld;
	}

	/**
	 * The number of locks currently in use by this cache. May return null if
	 * the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfLocksHeld(java.lang.Integer value) {
		Object oldValue = this.numberOfLocksHeld;
		this.numberOfLocksHeld = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfLocksHeld", oldValue, value);
		return (T) this;
	}

	/**
	 * If true, a pool of shared locks is maintained for all entries that need
	 * to be locked. Otherwise, a lock is created per entry in the cache. Lock
	 * striping helps control memory footprint but may reduce concurrency in the
	 * system.
	 */
	@ModelNodeBinding(detypedName = "striping")
	public Boolean striping() {
		return this.striping;
	}

	/**
	 * If true, a pool of shared locks is maintained for all entries that need
	 * to be locked. Otherwise, a lock is created per entry in the cache. Lock
	 * striping helps control memory footprint but may reduce concurrency in the
	 * system.
	 */
	@SuppressWarnings("unchecked")
	public T striping(java.lang.Boolean value) {
		Object oldValue = this.striping;
		this.striping = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("striping", oldValue, value);
		return (T) this;
	}
}