package org.wildfly.swarm.config.io;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Defines workers
 */
@Address("/subsystem=io/worker=*")
@ResourceType("worker")
public class Worker<T extends Worker<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Integer ioThreads;
	private Long stackSize;
	private Integer taskKeepalive;
	private Integer taskMaxThreads;

	public Worker(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Specify the number of I/O threads to create for the worker. If not
	 * specified, a default will be chosen, which is calculated by cpuCount * 2
	 */
	@ModelNodeBinding(detypedName = "io-threads")
	public Integer ioThreads() {
		return this.ioThreads;
	}

	/**
	 * Specify the number of I/O threads to create for the worker. If not
	 * specified, a default will be chosen, which is calculated by cpuCount * 2
	 */
	@SuppressWarnings("unchecked")
	public T ioThreads(java.lang.Integer value) {
		Object oldValue = this.ioThreads;
		this.ioThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ioThreads", oldValue, value);
		return (T) this;
	}

	/**
	 * The stack size (in bytes) to attempt to use for worker threads.
	 */
	@ModelNodeBinding(detypedName = "stack-size")
	public Long stackSize() {
		return this.stackSize;
	}

	/**
	 * The stack size (in bytes) to attempt to use for worker threads.
	 */
	@SuppressWarnings("unchecked")
	public T stackSize(java.lang.Long value) {
		Object oldValue = this.stackSize;
		this.stackSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stackSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Specify the number of milliseconds to keep non-core task threads alive.
	 */
	@ModelNodeBinding(detypedName = "task-keepalive")
	public Integer taskKeepalive() {
		return this.taskKeepalive;
	}

	/**
	 * Specify the number of milliseconds to keep non-core task threads alive.
	 */
	@SuppressWarnings("unchecked")
	public T taskKeepalive(java.lang.Integer value) {
		Object oldValue = this.taskKeepalive;
		this.taskKeepalive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("taskKeepalive", oldValue, value);
		return (T) this;
	}

	/**
	 * Specify the maximum number of threads for the worker task thread pool.If
	 * not set, default value used which is calculated by formula cpuCount * 16
	 */
	@ModelNodeBinding(detypedName = "task-max-threads")
	public Integer taskMaxThreads() {
		return this.taskMaxThreads;
	}

	/**
	 * Specify the maximum number of threads for the worker task thread pool.If
	 * not set, default value used which is calculated by formula cpuCount * 16
	 */
	@SuppressWarnings("unchecked")
	public T taskMaxThreads(java.lang.Integer value) {
		Object oldValue = this.taskMaxThreads;
		this.taskMaxThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("taskMaxThreads", oldValue, value);
		return (T) this;
	}
}