package org.wildfly.swarm.config.jgroups.stack.transport;

import org.wildfly.swarm.config.jgroups.stack.transport.DefaultThreadPool;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface DefaultThreadPoolConsumer<T extends DefaultThreadPool<T>> {

	/**
	 * Configure a pre-constructed instance of DefaultThreadPool resource
	 * 
	 * @parameter Instance of DefaultThreadPool to configure
	 * @return nothing
	 */
	void accept(T value);

	default DefaultThreadPoolConsumer<T> andThen(
			DefaultThreadPoolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}