package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configuration of the local authentication mechanism.
 */
@Address("/core-service=management/security-realm=*/authentication=local")
@ResourceType("authentication")
@Implicit
public class LocalAuthentication<T extends LocalAuthentication<T>>
		extends
			HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String allowedUsers;
	private String defaultUser;
	private Boolean skipGroupLoading;

	public LocalAuthentication() {
		super();
		this.key = "local";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The comma separated list of users that will be accepted using the
	 * JBOSS-LOCAL-USER mechanism or '*' to accept all. If specified the
	 * default-user is always assumed allowed.
	 */
	@ModelNodeBinding(detypedName = "allowed-users")
	public String allowedUsers() {
		return this.allowedUsers;
	}

	/**
	 * The comma separated list of users that will be accepted using the
	 * JBOSS-LOCAL-USER mechanism or '*' to accept all. If specified the
	 * default-user is always assumed allowed.
	 */
	@SuppressWarnings("unchecked")
	public T allowedUsers(java.lang.String value) {
		Object oldValue = this.allowedUsers;
		this.allowedUsers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowedUsers", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the default user to assume if no user specified by the remote
	 * client.
	 */
	@ModelNodeBinding(detypedName = "default-user")
	public String defaultUser() {
		return this.defaultUser;
	}

	/**
	 * The name of the default user to assume if no user specified by the remote
	 * client.
	 */
	@SuppressWarnings("unchecked")
	public T defaultUser(java.lang.String value) {
		Object oldValue = this.defaultUser;
		this.defaultUser = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultUser", oldValue, value);
		return (T) this;
	}

	/**
	 * Disable the loading of the users group membership information after local
	 * authentication has been used.
	 */
	@ModelNodeBinding(detypedName = "skip-group-loading")
	public Boolean skipGroupLoading() {
		return this.skipGroupLoading;
	}

	/**
	 * Disable the loading of the users group membership information after local
	 * authentication has been used.
	 */
	@SuppressWarnings("unchecked")
	public T skipGroupLoading(java.lang.Boolean value) {
		Object oldValue = this.skipGroupLoading;
		this.skipGroupLoading = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("skipGroupLoading", oldValue, value);
		return (T) this;
	}
}