package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;

/**
 * Defines a JMS queue.
 */
@Address("/subsystem=messaging-activemq/server=*/jms-queue=*")
@ResourceType("jms-queue")
public class JMSQueue<T extends JMSQueue<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Integer consumerCount;
	private String deadLetterAddress;
	private Integer deliveringCount;
	private Boolean durable;
	private List<String> entries;
	private String expiryAddress;
	private List<String> legacyEntries;
	private Long messageCount;
	private Long messagesAdded;
	private Boolean paused;
	private String queueAddress;
	private Long scheduledCount;
	private String selector;
	private Boolean temporary;

	public JMSQueue(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The number of consumers consuming messages from this queue.
	 */
	@ModelNodeBinding(detypedName = "consumer-count")
	public Integer consumerCount() {
		return this.consumerCount;
	}

	/**
	 * The number of consumers consuming messages from this queue.
	 */
	@SuppressWarnings("unchecked")
	public T consumerCount(java.lang.Integer value) {
		Object oldValue = this.consumerCount;
		this.consumerCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("consumerCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The address to send dead messages to.
	 */
	@ModelNodeBinding(detypedName = "dead-letter-address")
	public String deadLetterAddress() {
		return this.deadLetterAddress;
	}

	/**
	 * The address to send dead messages to.
	 */
	@SuppressWarnings("unchecked")
	public T deadLetterAddress(java.lang.String value) {
		Object oldValue = this.deadLetterAddress;
		this.deadLetterAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("deadLetterAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of messages that this queue is currently delivering to its
	 * consumers.
	 */
	@ModelNodeBinding(detypedName = "delivering-count")
	public Integer deliveringCount() {
		return this.deliveringCount;
	}

	/**
	 * The number of messages that this queue is currently delivering to its
	 * consumers.
	 */
	@SuppressWarnings("unchecked")
	public T deliveringCount(java.lang.Integer value) {
		Object oldValue = this.deliveringCount;
		this.deliveringCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("deliveringCount", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the queue is durable or not.
	 */
	@ModelNodeBinding(detypedName = "durable")
	public Boolean durable() {
		return this.durable;
	}

	/**
	 * Whether the queue is durable or not.
	 */
	@SuppressWarnings("unchecked")
	public T durable(java.lang.Boolean value) {
		Object oldValue = this.durable;
		this.durable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("durable", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(java.util.List<String> value) {
		Object oldValue = this.entries;
		this.entries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("entries", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entry(String value) {
		if (this.entries == null) {
			this.entries = new java.util.ArrayList<>();
		}
		this.entries.add(value);
		return (T) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(String... args) {
		entries(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The address to send expired messages to.
	 */
	@ModelNodeBinding(detypedName = "expiry-address")
	public String expiryAddress() {
		return this.expiryAddress;
	}

	/**
	 * The address to send expired messages to.
	 */
	@SuppressWarnings("unchecked")
	public T expiryAddress(java.lang.String value) {
		Object oldValue = this.expiryAddress;
		this.expiryAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("expiryAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@ModelNodeBinding(detypedName = "legacy-entries")
	public List<String> legacyEntries() {
		return this.legacyEntries;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T legacyEntries(java.util.List<String> value) {
		Object oldValue = this.legacyEntries;
		this.legacyEntries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("legacyEntries", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T legacyEntry(String value) {
		if (this.legacyEntries == null) {
			this.legacyEntries = new java.util.ArrayList<>();
		}
		this.legacyEntries.add(value);
		return (T) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T legacyEntries(String... args) {
		legacyEntries(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@ModelNodeBinding(detypedName = "message-count")
	public Long messageCount() {
		return this.messageCount;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@SuppressWarnings("unchecked")
	public T messageCount(java.lang.Long value) {
		Object oldValue = this.messageCount;
		this.messageCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messageCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@ModelNodeBinding(detypedName = "messages-added")
	public Long messagesAdded() {
		return this.messagesAdded;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@SuppressWarnings("unchecked")
	public T messagesAdded(java.lang.Long value) {
		Object oldValue = this.messagesAdded;
		this.messagesAdded = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messagesAdded", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the queue is paused.
	 */
	@ModelNodeBinding(detypedName = "paused")
	public Boolean paused() {
		return this.paused;
	}

	/**
	 * Whether the queue is paused.
	 */
	@SuppressWarnings("unchecked")
	public T paused(java.lang.Boolean value) {
		Object oldValue = this.paused;
		this.paused = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("paused", oldValue, value);
		return (T) this;
	}

	/**
	 * The queue address defines what address is used for routing messages.
	 */
	@ModelNodeBinding(detypedName = "queue-address")
	public String queueAddress() {
		return this.queueAddress;
	}

	/**
	 * The queue address defines what address is used for routing messages.
	 */
	@SuppressWarnings("unchecked")
	public T queueAddress(java.lang.String value) {
		Object oldValue = this.queueAddress;
		this.queueAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queueAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of scheduled messages in this queue.
	 */
	@ModelNodeBinding(detypedName = "scheduled-count")
	public Long scheduledCount() {
		return this.scheduledCount;
	}

	/**
	 * The number of scheduled messages in this queue.
	 */
	@SuppressWarnings("unchecked")
	public T scheduledCount(java.lang.Long value) {
		Object oldValue = this.scheduledCount;
		this.scheduledCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("scheduledCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The queue selector.
	 */
	@ModelNodeBinding(detypedName = "selector")
	public String selector() {
		return this.selector;
	}

	/**
	 * The queue selector.
	 */
	@SuppressWarnings("unchecked")
	public T selector(java.lang.String value) {
		Object oldValue = this.selector;
		this.selector = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("selector", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the queue is temporary.
	 */
	@ModelNodeBinding(detypedName = "temporary")
	public Boolean temporary() {
		return this.temporary;
	}

	/**
	 * Whether the queue is temporary.
	 */
	@SuppressWarnings("unchecked")
	public T temporary(java.lang.Boolean value) {
		Object oldValue = this.temporary;
		this.temporary = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("temporary", oldValue, value);
		return (T) this;
	}
}