package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.runtime.Addresses;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Properties supported by the underlying provider. The property name is
 * inferred from the last element of the properties address.
 */
@Addresses({"/subsystem=remoting/http-connector=*/property=*",
		"/subsystem=remoting/http-connector=*/security=sasl/property=*",
		"/subsystem=remoting/connector=*/property=*",
		"/subsystem=remoting/connector=*/security=sasl/property=*",
		"/subsystem=remoting/outbound-connection=*/property=*",
		"/subsystem=remoting/local-outbound-connection=*/property=*",
		"/subsystem=remoting/remote-outbound-connection=*/property=*"})
@ResourceType("property")
public class Property<T extends Property<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String value;

	public Property(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The property value.
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The property value.
	 */
	@SuppressWarnings("unchecked")
	public T value(java.lang.String value) {
		Object oldValue = this.value;
		this.value = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("value", oldValue, value);
		return (T) this;
	}
}