package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A filter parsed from the undertow expression language
 */
@Address("/subsystem=undertow/configuration=filter/expression-filter=*")
@ResourceType("expression-filter")
public class ExpressionFilter<T extends ExpressionFilter<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String expression;
	private String module;

	public ExpressionFilter(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The expression that defines the filter
	 */
	@ModelNodeBinding(detypedName = "expression")
	public String expression() {
		return this.expression;
	}

	/**
	 * The expression that defines the filter
	 */
	@SuppressWarnings("unchecked")
	public T expression(java.lang.String value) {
		Object oldValue = this.expression;
		this.expression = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("expression", oldValue, value);
		return (T) this;
	}

	/**
	 * Module to use to load the filter definitions
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Module to use to load the filter definitions
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}
}