/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.datasources.DataSource;
import org.wildfly.swarm.config.datasources.DataSourceConsumer;
import org.wildfly.swarm.config.datasources.DataSourceSupplier;
import org.wildfly.swarm.config.datasources.JDBCDriver;
import org.wildfly.swarm.config.datasources.JDBCDriverConsumer;
import org.wildfly.swarm.config.datasources.JDBCDriverSupplier;
import org.wildfly.swarm.config.datasources.XADataSource;
import org.wildfly.swarm.config.datasources.XADataSourceConsumer;
import org.wildfly.swarm.config.datasources.XADataSourceSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=datasources")
@ResourceType(value="subsystem")
@Implicit
public class Datasources<T extends Datasources<T>>
extends HashMap {
    private String key = "datasources";
    private PropertyChangeSupport pcs;
    private DatasourcesResources subresources = new DatasourcesResources();
    private List<Map> installedDrivers;

    public Datasources() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public DatasourcesResources subresources() {
        return this.subresources;
    }

    public T jdbcDrivers(List<JDBCDriver> value) {
        this.subresources.jdbcDrivers = value;
        return (T)this;
    }

    public T jdbcDriver(JDBCDriver value) {
        this.subresources.jdbcDrivers.add(value);
        return (T)this;
    }

    public T jdbcDriver(String childKey, JDBCDriverConsumer consumer) {
        JDBCDriver child = new JDBCDriver(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.jdbcDriver(child);
        return (T)this;
    }

    public T jdbcDriver(String childKey) {
        this.jdbcDriver(childKey, null);
        return (T)this;
    }

    public T jdbcDriver(JDBCDriverSupplier supplier) {
        this.jdbcDriver(supplier.get());
        return (T)this;
    }

    public T xaDataSources(List<XADataSource> value) {
        this.subresources.xaDataSources = value;
        return (T)this;
    }

    public T xaDataSource(XADataSource value) {
        this.subresources.xaDataSources.add(value);
        return (T)this;
    }

    public T xaDataSource(String childKey, XADataSourceConsumer consumer) {
        XADataSource child = new XADataSource(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.xaDataSource(child);
        return (T)this;
    }

    public T xaDataSource(String childKey) {
        this.xaDataSource(childKey, null);
        return (T)this;
    }

    public T xaDataSource(XADataSourceSupplier supplier) {
        this.xaDataSource(supplier.get());
        return (T)this;
    }

    public T dataSources(List<DataSource> value) {
        this.subresources.dataSources = value;
        return (T)this;
    }

    public T dataSource(DataSource value) {
        this.subresources.dataSources.add(value);
        return (T)this;
    }

    public T dataSource(String childKey, DataSourceConsumer consumer) {
        DataSource child = new DataSource(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.dataSource(child);
        return (T)this;
    }

    public T dataSource(String childKey) {
        this.dataSource(childKey, null);
        return (T)this;
    }

    public T dataSource(DataSourceSupplier supplier) {
        this.dataSource(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="installed-drivers")
    public List<Map> installedDrivers() {
        return this.installedDrivers;
    }

    public T installedDrivers(List<Map> value) {
        List<Map> oldValue = this.installedDrivers;
        this.installedDrivers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("installedDrivers", oldValue, value);
        }
        return (T)this;
    }

    public T installedDriver(Map value) {
        if (this.installedDrivers == null) {
            this.installedDrivers = new ArrayList<Map>();
        }
        this.installedDrivers.add(value);
        return (T)this;
    }

    public T installedDrivers(Map ... args) {
        this.installedDrivers(Arrays.asList(args));
        return (T)this;
    }

    public static class DatasourcesResources {
        private List<JDBCDriver> jdbcDrivers = new ArrayList<JDBCDriver>();
        private List<XADataSource> xaDataSources = new ArrayList<XADataSource>();
        private List<DataSource> dataSources = new ArrayList<DataSource>();

        @Subresource
        public List<JDBCDriver> jdbcDrivers() {
            return this.jdbcDrivers;
        }

        public JDBCDriver jdbcDriver(String key) {
            return this.jdbcDrivers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<XADataSource> xaDataSources() {
            return this.xaDataSources;
        }

        public XADataSource xaDataSource(String key) {
            return this.xaDataSources.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<DataSource> dataSources() {
            return this.dataSources;
        }

        public DataSource dataSource(String key) {
            return this.dataSources.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

