/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.remoting;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=remoting/http-connector=*/property=*", "/subsystem=remoting/http-connector=*/security=sasl/property=*", "/subsystem=remoting/connector=*/property=*", "/subsystem=remoting/connector=*/security=sasl/property=*", "/subsystem=remoting/outbound-connection=*/property=*", "/subsystem=remoting/local-outbound-connection=*/property=*", "/subsystem=remoting/remote-outbound-connection=*/property=*"})
@ResourceType(value="property")
public class Property<T extends Property<T>>
extends HashMap {
    private String key;
    private PropertyChangeSupport pcs;
    private String value;

    public Property(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="value")
    public String value() {
        return this.value;
    }

    public T value(String value) {
        String oldValue = this.value;
        this.value = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("value", oldValue, value);
        }
        return (T)this;
    }
}

