/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security.security_domain;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.mapping.MappingModule;
import org.wildfly.swarm.config.security.security_domain.mapping.MappingModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.mapping.MappingModuleSupplier;

@Address(value="/subsystem=security/security-domain=*/mapping=classic")
@ResourceType(value="mapping")
@Implicit
public class ClassicMapping<T extends ClassicMapping<T>>
extends HashMap {
    private String key = "classic";
    private PropertyChangeSupport pcs;
    private ClassicMappingResources subresources = new ClassicMappingResources();

    public ClassicMapping() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ClassicMappingResources subresources() {
        return this.subresources;
    }

    public T mappingModules(List<MappingModule> value) {
        this.subresources.mappingModules = value;
        return (T)this;
    }

    public T mappingModule(MappingModule value) {
        this.subresources.mappingModules.add(value);
        return (T)this;
    }

    public T mappingModule(String childKey, MappingModuleConsumer consumer) {
        MappingModule child = new MappingModule(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.mappingModule(child);
        return (T)this;
    }

    public T mappingModule(String childKey) {
        this.mappingModule(childKey, null);
        return (T)this;
    }

    public T mappingModule(MappingModuleSupplier supplier) {
        this.mappingModule(supplier.get());
        return (T)this;
    }

    public static class ClassicMappingResources {
        private List<MappingModule> mappingModules = new ArrayList<MappingModule>();

        @Subresource
        public List<MappingModule> mappingModules() {
            return this.mappingModules;
        }

        public MappingModule mappingModule(String key) {
            return this.mappingModules.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

