package org.wildfly.swarm.config.io;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Defines buffer pool
 */
@Address("/subsystem=io/buffer-pool=*")
@ResourceType("buffer-pool")
public class BufferPool<T extends BufferPool<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Integer bufferSize;
	private Integer buffersPerSlice;
	private Boolean directBuffers;

	public BufferPool(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The size of each buffer slice in bytes, if not set optimal value is
	 * calculated based on available RAM resources in your system.
	 */
	@ModelNodeBinding(detypedName = "buffer-size")
	public Integer bufferSize() {
		return this.bufferSize;
	}

	/**
	 * The size of each buffer slice in bytes, if not set optimal value is
	 * calculated based on available RAM resources in your system.
	 */
	@SuppressWarnings("unchecked")
	public T bufferSize(java.lang.Integer value) {
		Object oldValue = this.bufferSize;
		this.bufferSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bufferSize", oldValue, value);
		return (T) this;
	}

	/**
	 * How many buffers per slice, if not set optimal value is calculated based
	 * on available RAM resources in your system.
	 */
	@ModelNodeBinding(detypedName = "buffers-per-slice")
	public Integer buffersPerSlice() {
		return this.buffersPerSlice;
	}

	/**
	 * How many buffers per slice, if not set optimal value is calculated based
	 * on available RAM resources in your system.
	 */
	@SuppressWarnings("unchecked")
	public T buffersPerSlice(java.lang.Integer value) {
		Object oldValue = this.buffersPerSlice;
		this.buffersPerSlice = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("buffersPerSlice", oldValue, value);
		return (T) this;
	}

	/**
	 * Does the buffer pool use direct buffers, some platforms don't support
	 * direct buffers
	 */
	@ModelNodeBinding(detypedName = "direct-buffers")
	public Boolean directBuffers() {
		return this.directBuffers;
	}

	/**
	 * Does the buffer pool use direct buffers, some platforms don't support
	 * direct buffers
	 */
	@SuppressWarnings("unchecked")
	public T directBuffers(java.lang.Boolean value) {
		Object oldValue = this.directBuffers;
		this.directBuffers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("directBuffers", oldValue, value);
		return (T) this;
	}
}