package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.jca.LongRunningThreadsConsumer;
import org.wildfly.swarm.config.jca.LongRunningThreadsSupplier;
import org.wildfly.swarm.config.jca.LongRunningThreads;
import org.wildfly.swarm.config.jca.ShortRunningThreadsConsumer;
import org.wildfly.swarm.config.jca.ShortRunningThreadsSupplier;
import org.wildfly.swarm.config.jca.ShortRunningThreads;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * WorkManager for resource adapters
 */
@Address("/subsystem=jca/workmanager=*")
@ResourceType("workmanager")
public class Workmanager<T extends Workmanager<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private WorkmanagerResources subresources = new WorkmanagerResources();
	private String name;

	public Workmanager(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public WorkmanagerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all LongRunningThreads objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LongRunningThreads objects.
	 */
	@SuppressWarnings("unchecked")
	public T longRunningThreads(java.util.List<LongRunningThreads> value) {
		this.subresources.longRunningThreads = value;
		return (T) this;
	}

	/**
	 * Add the LongRunningThreads object to the list of subresources
	 * 
	 * @param value
	 *            The LongRunningThreads to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T longRunningThreads(LongRunningThreads value) {
		this.subresources.longRunningThreads.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LongRunningThreads object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LongRunningThreads resource
	 * @param config
	 *            The LongRunningThreadsConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T longRunningThreads(java.lang.String childKey,
			LongRunningThreadsConsumer consumer) {
		LongRunningThreads<? extends LongRunningThreads> child = new LongRunningThreads<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		longRunningThreads(child);
		return (T) this;
	}

	/**
	 * Create and configure a LongRunningThreads object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LongRunningThreads resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T longRunningThreads(java.lang.String childKey) {
		longRunningThreads(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LongRunningThreads object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T longRunningThreads(LongRunningThreadsSupplier supplier) {
		longRunningThreads(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ShortRunningThreads objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ShortRunningThreads objects.
	 */
	@SuppressWarnings("unchecked")
	public T shortRunningThreads(java.util.List<ShortRunningThreads> value) {
		this.subresources.shortRunningThreads = value;
		return (T) this;
	}

	/**
	 * Add the ShortRunningThreads object to the list of subresources
	 * 
	 * @param value
	 *            The ShortRunningThreads to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T shortRunningThreads(ShortRunningThreads value) {
		this.subresources.shortRunningThreads.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ShortRunningThreads object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ShortRunningThreads resource
	 * @param config
	 *            The ShortRunningThreadsConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T shortRunningThreads(java.lang.String childKey,
			ShortRunningThreadsConsumer consumer) {
		ShortRunningThreads<? extends ShortRunningThreads> child = new ShortRunningThreads<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		shortRunningThreads(child);
		return (T) this;
	}

	/**
	 * Create and configure a ShortRunningThreads object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ShortRunningThreads resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T shortRunningThreads(java.lang.String childKey) {
		shortRunningThreads(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ShortRunningThreads object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T shortRunningThreads(ShortRunningThreadsSupplier supplier) {
		shortRunningThreads(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Workmanager
	 */
	public static class WorkmanagerResources {
		/**
		 * A thread pool executor with a bounded queue where threads submittings
		 * tasks will not block. Such a thread pool has a core and maximum size
		 * and a specified queue length. When a task is submitted, if the number
		 * of running threads is less than the core size, a new thread is
		 * created. Otherwise, if there is room in the queue, the task is
		 * enqueued. Otherwise, if the number of running threads is less than
		 * the maximum size, a new thread is created. Otherwise, the task is
		 * handed off to the designated handoff executor, if one is specified.
		 * Otherwise, the task is discarded.
		 */
		private List<LongRunningThreads> longRunningThreads = new java.util.ArrayList<>();
		/**
		 * A thread pool executor with a bounded queue where threads submittings
		 * tasks will not block. Such a thread pool has a core and maximum size
		 * and a specified queue length. When a task is submitted, if the number
		 * of running threads is less than the core size, a new thread is
		 * created. Otherwise, if there is room in the queue, the task is
		 * enqueued. Otherwise, if the number of running threads is less than
		 * the maximum size, a new thread is created. Otherwise, the task is
		 * handed off to the designated handoff executor, if one is specified.
		 * Otherwise, the task is discarded.
		 */
		private List<ShortRunningThreads> shortRunningThreads = new java.util.ArrayList<>();

		/**
		 * Get the list of LongRunningThreads resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LongRunningThreads> longRunningThreads() {
			return this.longRunningThreads;
		}

		public LongRunningThreads longRunningThreads(java.lang.String key) {
			return this.longRunningThreads.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ShortRunningThreads resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ShortRunningThreads> shortRunningThreads() {
			return this.shortRunningThreads;
		}

		public ShortRunningThreads shortRunningThreads(java.lang.String key) {
			return this.shortRunningThreads.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * The name of the WorkManager
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the WorkManager
	 */
	@SuppressWarnings("unchecked")
	public T name(java.lang.String value) {
		Object oldValue = this.name;
		this.name = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("name", oldValue, value);
		return (T) this;
	}
}