package org.wildfly.swarm.config.jmx;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A JBoss remoting connector for the JMX subsystem.
 */
@Address("/subsystem=jmx/remoting-connector=jmx")
@ResourceType("remoting-connector")
@Implicit
public class JMXRemotingConnector<T extends JMXRemotingConnector<T>>
		extends
			HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean useManagementEndpoint;

	public JMXRemotingConnector() {
		super();
		this.key = "jmx";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * If true the connector will use the management endpoint, otherwise it will
	 * use the remoting subsystem one
	 */
	@ModelNodeBinding(detypedName = "use-management-endpoint")
	public Boolean useManagementEndpoint() {
		return this.useManagementEndpoint;
	}

	/**
	 * If true the connector will use the management endpoint, otherwise it will
	 * use the remoting subsystem one
	 */
	@SuppressWarnings("unchecked")
	public T useManagementEndpoint(java.lang.Boolean value) {
		Object oldValue = this.useManagementEndpoint;
		this.useManagementEndpoint = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useManagementEndpoint", oldValue,
					value);
		return (T) this;
	}
}