package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.runtime.Addresses;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.logging.Level;

/**
 * Defines a handler which writes to the console.
 */
@Addresses({"/subsystem=logging/logging-profile=*/console-handler=*",
		"/subsystem=logging/console-handler=*"})
@ResourceType("console-handler")
public class ConsoleHandler<T extends ConsoleHandler<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean autoflush;
	private Boolean enabled;
	private String encoding;
	private String filterSpec;
	private String formatter;
	private Level level;
	private String namedFormatter;
	private Target target;

	public ConsoleHandler(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum Target {
		CONSOLE("console"), SYSTEM_OUT("System.out"), SYSTEM_ERR("System.err");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Target(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * Automatically flush after each write.
	 */
	@ModelNodeBinding(detypedName = "autoflush")
	public Boolean autoflush() {
		return this.autoflush;
	}

	/**
	 * Automatically flush after each write.
	 */
	@SuppressWarnings("unchecked")
	public T autoflush(java.lang.Boolean value) {
		Object oldValue = this.autoflush;
		this.autoflush = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("autoflush", oldValue, value);
		return (T) this;
	}

	/**
	 * If set to true the handler is enabled and functioning as normal, if set
	 * to false the handler is ignored when processing log messages.
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * If set to true the handler is enabled and functioning as normal, if set
	 * to false the handler is ignored when processing log messages.
	 */
	@SuppressWarnings("unchecked")
	public T enabled(java.lang.Boolean value) {
		Object oldValue = this.enabled;
		this.enabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The character encoding used by this Handler.
	 */
	@ModelNodeBinding(detypedName = "encoding")
	public String encoding() {
		return this.encoding;
	}

	/**
	 * The character encoding used by this Handler.
	 */
	@SuppressWarnings("unchecked")
	public T encoding(java.lang.String value) {
		Object oldValue = this.encoding;
		this.encoding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("encoding", oldValue, value);
		return (T) this;
	}

	/**
	 * A filter expression value to define a filter. Example for a filter that
	 * does not match a pattern: not(match("JBAS.*"))
	 */
	@ModelNodeBinding(detypedName = "filter-spec")
	public String filterSpec() {
		return this.filterSpec;
	}

	/**
	 * A filter expression value to define a filter. Example for a filter that
	 * does not match a pattern: not(match("JBAS.*"))
	 */
	@SuppressWarnings("unchecked")
	public T filterSpec(java.lang.String value) {
		Object oldValue = this.filterSpec;
		this.filterSpec = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filterSpec", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines a pattern for the formatter.
	 */
	@ModelNodeBinding(detypedName = "formatter")
	public String formatter() {
		return this.formatter;
	}

	/**
	 * Defines a pattern for the formatter.
	 */
	@SuppressWarnings("unchecked")
	public T formatter(java.lang.String value) {
		Object oldValue = this.formatter;
		this.formatter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("formatter", oldValue, value);
		return (T) this;
	}

	/**
	 * The log level specifying which message levels will be logged by this
	 * logger. Message levels lower than this value will be discarded.
	 */
	@ModelNodeBinding(detypedName = "level")
	public Level level() {
		return this.level;
	}

	/**
	 * The log level specifying which message levels will be logged by this
	 * logger. Message levels lower than this value will be discarded.
	 */
	@SuppressWarnings("unchecked")
	public T level(Level value) {
		Object oldValue = this.level;
		this.level = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("level", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the defined formatter to be used on the handler.
	 */
	@ModelNodeBinding(detypedName = "named-formatter")
	public String namedFormatter() {
		return this.namedFormatter;
	}

	/**
	 * The name of the defined formatter to be used on the handler.
	 */
	@SuppressWarnings("unchecked")
	public T namedFormatter(java.lang.String value) {
		Object oldValue = this.namedFormatter;
		this.namedFormatter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("namedFormatter", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the target of the console handler. The value can be System.out,
	 * System.err or console.
	 */
	@ModelNodeBinding(detypedName = "target")
	public Target target() {
		return this.target;
	}

	/**
	 * Defines the target of the console handler. The value can be System.out,
	 * System.err or console.
	 */
	@SuppressWarnings("unchecked")
	public T target(Target value) {
		Object oldValue = this.target;
		this.target = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("target", oldValue, value);
		return (T) this;
	}
}