package org.wildfly.swarm.config.management.access.constraint.type.classification;

import org.wildfly.swarm.config.runtime.Addresses;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;

/**
 * Information about the resources, attributes and operations to which an access
 * control constraint applies.
 */
@Addresses({
		"/core-service=management/access=authorization/constraint=application-classification/type=*/classification=*/applies-to=*",
		"/core-service=management/access=authorization/constraint=sensitivity-classification/type=*/classification=*/applies-to=*"})
@ResourceType("applies-to")
public class AppliesTo<T extends AppliesTo<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private String address;
	private List<String> attributes;
	private Boolean entireResource;
	private List<String> operations;

	public AppliesTo(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Address pattern describing a resource or resources to which the
	 * constraint applies.
	 */
	@ModelNodeBinding(detypedName = "address")
	public String address() {
		return this.address;
	}

	/**
	 * Address pattern describing a resource or resources to which the
	 * constraint applies.
	 */
	@SuppressWarnings("unchecked")
	public T address(java.lang.String value) {
		Object oldValue = this.address;
		this.address = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("address", oldValue, value);
		return (T) this;
	}

	/**
	 * List of the names of attributes to which the constraint specifically
	 * applies.
	 */
	@ModelNodeBinding(detypedName = "attributes")
	public List<String> attributes() {
		return this.attributes;
	}

	/**
	 * List of the names of attributes to which the constraint specifically
	 * applies.
	 */
	@SuppressWarnings("unchecked")
	public T attributes(java.util.List<String> value) {
		Object oldValue = this.attributes;
		this.attributes = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributes", oldValue, value);
		return (T) this;
	}

	/**
	 * List of the names of attributes to which the constraint specifically
	 * applies.
	 */
	@SuppressWarnings("unchecked")
	public T attribute(String value) {
		if (this.attributes == null) {
			this.attributes = new java.util.ArrayList<>();
		}
		this.attributes.add(value);
		return (T) this;
	}

	/**
	 * List of the names of attributes to which the constraint specifically
	 * applies.
	 */
	@SuppressWarnings("unchecked")
	public T attributes(String... args) {
		attributes(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * True if the constraint applies to the resource as a whole; false if it
	 * only applies to one or more attributes or operations.
	 */
	@ModelNodeBinding(detypedName = "entire-resource")
	public Boolean entireResource() {
		return this.entireResource;
	}

	/**
	 * True if the constraint applies to the resource as a whole; false if it
	 * only applies to one or more attributes or operations.
	 */
	@SuppressWarnings("unchecked")
	public T entireResource(java.lang.Boolean value) {
		Object oldValue = this.entireResource;
		this.entireResource = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("entireResource", oldValue, value);
		return (T) this;
	}

	/**
	 * List of the names of operations to which the constraint specifically
	 * applies.
	 */
	@ModelNodeBinding(detypedName = "operations")
	public List<String> operations() {
		return this.operations;
	}

	/**
	 * List of the names of operations to which the constraint specifically
	 * applies.
	 */
	@SuppressWarnings("unchecked")
	public T operations(java.util.List<String> value) {
		Object oldValue = this.operations;
		this.operations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("operations", oldValue, value);
		return (T) this;
	}

	/**
	 * List of the names of operations to which the constraint specifically
	 * applies.
	 */
	@SuppressWarnings("unchecked")
	public T operation(String value) {
		if (this.operations == null) {
			this.operations = new java.util.ArrayList<>();
		}
		this.operations.add(value);
		return (T) this;
	}

	/**
	 * List of the names of operations to which the constraint specifically
	 * applies.
	 */
	@SuppressWarnings("unchecked")
	public T operations(String... args) {
		operations(Arrays.asList(args));
		return (T) this;
	}
}