package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.runtime.Addresses;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.remoting.PropertyConsumer;
import org.wildfly.swarm.config.remoting.PropertySupplier;
import org.wildfly.swarm.config.remoting.Property;
import org.wildfly.swarm.config.remoting.PolicySASLPolicyConsumer;
import org.wildfly.swarm.config.remoting.PolicySASLPolicySupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * The "sasl" element contains the SASL authentication configuration for this
 * connector.
 */
@Addresses({"/subsystem=remoting/http-connector=*/security=sasl",
		"/subsystem=remoting/connector=*/security=sasl"})
@ResourceType("security")
@Implicit
public class SASLSecurity<T extends SASLSecurity<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private SASLSecurityResources subresources = new SASLSecurityResources();
	private List<String> includeMechanisms;
	private List<String> qop;
	private Boolean reuseSession;
	private Boolean serverAuth;
	private List<String> strength;

	public SASLSecurity() {
		super();
		this.key = "sasl";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public SASLSecurityResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Property objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Property objects.
	 */
	@SuppressWarnings("unchecked")
	public T properties(java.util.List<Property> value) {
		this.subresources.properties = value;
		return (T) this;
	}

	/**
	 * Add the Property object to the list of subresources
	 * 
	 * @param value
	 *            The Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(Property value) {
		this.subresources.properties.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Property object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Property resource
	 * @param config
	 *            The PropertyConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String childKey, PropertyConsumer consumer) {
		Property<? extends Property> child = new Property<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		property(child);
		return (T) this;
	}

	/**
	 * Create and configure a Property object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Property resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String childKey) {
		property(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Property object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T property(PropertySupplier supplier) {
		property(supplier.get());
		return (T) this;
	}

	/**
	 * The policy configuration.
	 */
	@SuppressWarnings("unchecked")
	public T policySaslPolicy(
			org.wildfly.swarm.config.remoting.PolicySASLPolicy value) {
		this.subresources.policySaslPolicy = value;
		return (T) this;
	}

	/**
	 * The policy configuration.
	 */
	@SuppressWarnings("unchecked")
	public T policySaslPolicy(PolicySASLPolicyConsumer consumer) {
		PolicySASLPolicy<? extends PolicySASLPolicy> child = new PolicySASLPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.policySaslPolicy = child;
		return (T) this;
	}

	/**
	 * The policy configuration.
	 */
	@SuppressWarnings("unchecked")
	public T policySaslPolicy() {
		PolicySASLPolicy<? extends PolicySASLPolicy> child = new PolicySASLPolicy<>();
		this.subresources.policySaslPolicy = child;
		return (T) this;
	}

	/**
	 * The policy configuration.
	 */
	@SuppressWarnings("unchecked")
	public T policySaslPolicy(PolicySASLPolicySupplier supplier) {
		this.subresources.policySaslPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for SASLSecurity
	 */
	public static class SASLSecurityResources {
		/**
		 * Properties supported by the underlying provider. The property name is
		 * inferred from the last element of the properties address.
		 */
		private List<Property> properties = new java.util.ArrayList<>();
		private PolicySASLPolicy policySaslPolicy;

		/**
		 * Get the list of Property resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> properties() {
			return this.properties;
		}

		public Property property(java.lang.String key) {
			return this.properties.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * The policy configuration.
		 */
		@Subresource
		public PolicySASLPolicy policySaslPolicy() {
			return this.policySaslPolicy;
		}
	}

	/**
	 * The optional nested "include-mechanisms" element contains a whitelist of
	 * allowed SASL mechanism names. No mechanisms will be allowed which are not
	 * present in this list.
	 */
	@ModelNodeBinding(detypedName = "include-mechanisms")
	public List<String> includeMechanisms() {
		return this.includeMechanisms;
	}

	/**
	 * The optional nested "include-mechanisms" element contains a whitelist of
	 * allowed SASL mechanism names. No mechanisms will be allowed which are not
	 * present in this list.
	 */
	@SuppressWarnings("unchecked")
	public T includeMechanisms(java.util.List<String> value) {
		Object oldValue = this.includeMechanisms;
		this.includeMechanisms = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("includeMechanisms", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional nested "include-mechanisms" element contains a whitelist of
	 * allowed SASL mechanism names. No mechanisms will be allowed which are not
	 * present in this list.
	 */
	@SuppressWarnings("unchecked")
	public T includeMechanism(String value) {
		if (this.includeMechanisms == null) {
			this.includeMechanisms = new java.util.ArrayList<>();
		}
		this.includeMechanisms.add(value);
		return (T) this;
	}

	/**
	 * The optional nested "include-mechanisms" element contains a whitelist of
	 * allowed SASL mechanism names. No mechanisms will be allowed which are not
	 * present in this list.
	 */
	@SuppressWarnings("unchecked")
	public T includeMechanisms(String... args) {
		includeMechanisms(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The optional nested "qop" element contains a list of
	 * quality-of-protection values, in decreasing order of preference.
	 */
	@ModelNodeBinding(detypedName = "qop")
	public List<String> qop() {
		return this.qop;
	}

	/**
	 * The optional nested "qop" element contains a list of
	 * quality-of-protection values, in decreasing order of preference.
	 */
	@SuppressWarnings("unchecked")
	public T qop(java.util.List<String> value) {
		Object oldValue = this.qop;
		this.qop = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("qop", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional nested "qop" element contains a list of
	 * quality-of-protection values, in decreasing order of preference.
	 */
	@SuppressWarnings("unchecked")
	public T qop(String value) {
		if (this.qop == null) {
			this.qop = new java.util.ArrayList<>();
		}
		this.qop.add(value);
		return (T) this;
	}

	/**
	 * The optional nested "qop" element contains a list of
	 * quality-of-protection values, in decreasing order of preference.
	 */
	@SuppressWarnings("unchecked")
	public T qop(String... args) {
		qop(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The optional nested "reuse-session" boolean element specifies whether or
	 * not the server should attempt to reuse previously authenticated session
	 * information. The mechanism may or may not support such reuse, and other
	 * factors may also prevent it.
	 */
	@ModelNodeBinding(detypedName = "reuse-session")
	public Boolean reuseSession() {
		return this.reuseSession;
	}

	/**
	 * The optional nested "reuse-session" boolean element specifies whether or
	 * not the server should attempt to reuse previously authenticated session
	 * information. The mechanism may or may not support such reuse, and other
	 * factors may also prevent it.
	 */
	@SuppressWarnings("unchecked")
	public T reuseSession(java.lang.Boolean value) {
		Object oldValue = this.reuseSession;
		this.reuseSession = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("reuseSession", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional nested "server-auth" boolean element specifies whether the
	 * server should authenticate to the client. Not all mechanisms may support
	 * this setting.
	 */
	@ModelNodeBinding(detypedName = "server-auth")
	public Boolean serverAuth() {
		return this.serverAuth;
	}

	/**
	 * The optional nested "server-auth" boolean element specifies whether the
	 * server should authenticate to the client. Not all mechanisms may support
	 * this setting.
	 */
	@SuppressWarnings("unchecked")
	public T serverAuth(java.lang.Boolean value) {
		Object oldValue = this.serverAuth;
		this.serverAuth = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverAuth", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional nested "strength" element contains a list of cipher strength
	 * values, in decreasing order of preference.
	 */
	@ModelNodeBinding(detypedName = "strength")
	public List<String> strength() {
		return this.strength;
	}

	/**
	 * The optional nested "strength" element contains a list of cipher strength
	 * values, in decreasing order of preference.
	 */
	@SuppressWarnings("unchecked")
	public T strength(java.util.List<String> value) {
		Object oldValue = this.strength;
		this.strength = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("strength", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional nested "strength" element contains a list of cipher strength
	 * values, in decreasing order of preference.
	 */
	@SuppressWarnings("unchecked")
	public T strength(String value) {
		if (this.strength == null) {
			this.strength = new java.util.ArrayList<>();
		}
		this.strength.add(value);
		return (T) this;
	}

	/**
	 * The optional nested "strength" element contains a list of cipher strength
	 * values, in decreasing order of preference.
	 */
	@SuppressWarnings("unchecked")
	public T strength(String... args) {
		strength(Arrays.asList(args));
		return (T) this;
	}
}