package org.wildfly.swarm.config.webservices;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.webservices.PostHandlerChainConsumer;
import org.wildfly.swarm.config.webservices.PostHandlerChainSupplier;
import org.wildfly.swarm.config.webservices.PostHandlerChain;
import org.wildfly.swarm.config.webservices.PreHandlerChainConsumer;
import org.wildfly.swarm.config.webservices.PreHandlerChainSupplier;
import org.wildfly.swarm.config.webservices.PreHandlerChain;
import org.wildfly.swarm.config.webservices.PropertyConsumer;
import org.wildfly.swarm.config.webservices.PropertySupplier;
import org.wildfly.swarm.config.webservices.Property;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Webservice endpoint configuration
 */
@Address("/subsystem=webservices/endpoint-config=*")
@ResourceType("endpoint-config")
public class EndpointConfig<T extends EndpointConfig<T>> extends HashMap {

	private String key;
	private PropertyChangeSupport pcs;
	private EndpointConfigResources subresources = new EndpointConfigResources();

	public EndpointConfig(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public EndpointConfigResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all PostHandlerChain objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PostHandlerChain objects.
	 */
	@SuppressWarnings("unchecked")
	public T postHandlerChains(java.util.List<PostHandlerChain> value) {
		this.subresources.postHandlerChains = value;
		return (T) this;
	}

	/**
	 * Add the PostHandlerChain object to the list of subresources
	 * 
	 * @param value
	 *            The PostHandlerChain to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T postHandlerChain(PostHandlerChain value) {
		this.subresources.postHandlerChains.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PostHandlerChain object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PostHandlerChain resource
	 * @param config
	 *            The PostHandlerChainConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T postHandlerChain(java.lang.String childKey,
			PostHandlerChainConsumer consumer) {
		PostHandlerChain<? extends PostHandlerChain> child = new PostHandlerChain<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		postHandlerChain(child);
		return (T) this;
	}

	/**
	 * Create and configure a PostHandlerChain object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PostHandlerChain resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T postHandlerChain(java.lang.String childKey) {
		postHandlerChain(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PostHandlerChain object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T postHandlerChain(PostHandlerChainSupplier supplier) {
		postHandlerChain(supplier.get());
		return (T) this;
	}

	/**
	 * Add all PreHandlerChain objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PreHandlerChain objects.
	 */
	@SuppressWarnings("unchecked")
	public T preHandlerChains(java.util.List<PreHandlerChain> value) {
		this.subresources.preHandlerChains = value;
		return (T) this;
	}

	/**
	 * Add the PreHandlerChain object to the list of subresources
	 * 
	 * @param value
	 *            The PreHandlerChain to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T preHandlerChain(PreHandlerChain value) {
		this.subresources.preHandlerChains.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PreHandlerChain object to the list of subresources
	 * 
	 * @param key
	 *            The key for the PreHandlerChain resource
	 * @param config
	 *            The PreHandlerChainConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T preHandlerChain(java.lang.String childKey,
			PreHandlerChainConsumer consumer) {
		PreHandlerChain<? extends PreHandlerChain> child = new PreHandlerChain<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		preHandlerChain(child);
		return (T) this;
	}

	/**
	 * Create and configure a PreHandlerChain object to the list of subresources
	 * 
	 * @param key
	 *            The key for the PreHandlerChain resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T preHandlerChain(java.lang.String childKey) {
		preHandlerChain(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PreHandlerChain object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T preHandlerChain(PreHandlerChainSupplier supplier) {
		preHandlerChain(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Property objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Property objects.
	 */
	@SuppressWarnings("unchecked")
	public T properties(java.util.List<Property> value) {
		this.subresources.properties = value;
		return (T) this;
	}

	/**
	 * Add the Property object to the list of subresources
	 * 
	 * @param value
	 *            The Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(Property value) {
		this.subresources.properties.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Property object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Property resource
	 * @param config
	 *            The PropertyConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String childKey, PropertyConsumer consumer) {
		Property<? extends Property> child = new Property<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		property(child);
		return (T) this;
	}

	/**
	 * Create and configure a Property object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Property resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String childKey) {
		property(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Property object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T property(PropertySupplier supplier) {
		property(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for EndpointConfig
	 */
	public static class EndpointConfigResources {
		/**
		 * Endpoint configuration POST handler chain
		 */
		private List<PostHandlerChain> postHandlerChains = new java.util.ArrayList<>();
		/**
		 * Endpoint configuration PRE handler chain
		 */
		private List<PreHandlerChain> preHandlerChains = new java.util.ArrayList<>();
		/**
		 * Endpoint configuration property
		 */
		private List<Property> properties = new java.util.ArrayList<>();

		/**
		 * Get the list of PostHandlerChain resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PostHandlerChain> postHandlerChains() {
			return this.postHandlerChains;
		}

		public PostHandlerChain postHandlerChain(java.lang.String key) {
			return this.postHandlerChains.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of PreHandlerChain resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PreHandlerChain> preHandlerChains() {
			return this.preHandlerChains;
		}

		public PreHandlerChain preHandlerChain(java.lang.String key) {
			return this.preHandlerChains.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Property resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> properties() {
			return this.properties;
		}

		public Property property(java.lang.String key) {
			return this.properties.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}
}