/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.remoting.Connector;
import org.wildfly.swarm.config.remoting.ConnectorConsumer;
import org.wildfly.swarm.config.remoting.ConnectorSupplier;
import org.wildfly.swarm.config.remoting.EndpointConfiguration;
import org.wildfly.swarm.config.remoting.EndpointConfigurationConsumer;
import org.wildfly.swarm.config.remoting.EndpointConfigurationSupplier;
import org.wildfly.swarm.config.remoting.HTTPConnector;
import org.wildfly.swarm.config.remoting.HTTPConnectorConsumer;
import org.wildfly.swarm.config.remoting.HTTPConnectorSupplier;
import org.wildfly.swarm.config.remoting.LocalOutboundConnection;
import org.wildfly.swarm.config.remoting.LocalOutboundConnectionConsumer;
import org.wildfly.swarm.config.remoting.LocalOutboundConnectionSupplier;
import org.wildfly.swarm.config.remoting.OutboundConnection;
import org.wildfly.swarm.config.remoting.OutboundConnectionConsumer;
import org.wildfly.swarm.config.remoting.OutboundConnectionSupplier;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnection;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnectionConsumer;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnectionSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=remoting")
@ResourceType(value="subsystem")
@Implicit
public class Remoting<T extends Remoting<T>>
extends HashMap {
    private String key = "remoting";
    private PropertyChangeSupport pcs;
    private RemotingResources subresources = new RemotingResources();

    public Remoting() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public RemotingResources subresources() {
        return this.subresources;
    }

    public T httpConnectors(List<HTTPConnector> value) {
        this.subresources.httpConnectors = value;
        return (T)this;
    }

    public T httpConnector(HTTPConnector value) {
        this.subresources.httpConnectors.add(value);
        return (T)this;
    }

    public T httpConnector(String childKey, HTTPConnectorConsumer consumer) {
        HTTPConnector child = new HTTPConnector(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.httpConnector(child);
        return (T)this;
    }

    public T httpConnector(String childKey) {
        this.httpConnector(childKey, null);
        return (T)this;
    }

    public T httpConnector(HTTPConnectorSupplier supplier) {
        this.httpConnector(supplier.get());
        return (T)this;
    }

    public T connectors(List<Connector> value) {
        this.subresources.connectors = value;
        return (T)this;
    }

    public T connector(Connector value) {
        this.subresources.connectors.add(value);
        return (T)this;
    }

    public T connector(String childKey, ConnectorConsumer consumer) {
        Connector child = new Connector(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.connector(child);
        return (T)this;
    }

    public T connector(String childKey) {
        this.connector(childKey, null);
        return (T)this;
    }

    public T connector(ConnectorSupplier supplier) {
        this.connector(supplier.get());
        return (T)this;
    }

    public T outboundConnections(List<OutboundConnection> value) {
        this.subresources.outboundConnections = value;
        return (T)this;
    }

    public T outboundConnection(OutboundConnection value) {
        this.subresources.outboundConnections.add(value);
        return (T)this;
    }

    public T outboundConnection(String childKey, OutboundConnectionConsumer consumer) {
        OutboundConnection child = new OutboundConnection(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.outboundConnection(child);
        return (T)this;
    }

    public T outboundConnection(String childKey) {
        this.outboundConnection(childKey, null);
        return (T)this;
    }

    public T outboundConnection(OutboundConnectionSupplier supplier) {
        this.outboundConnection(supplier.get());
        return (T)this;
    }

    public T localOutboundConnections(List<LocalOutboundConnection> value) {
        this.subresources.localOutboundConnections = value;
        return (T)this;
    }

    public T localOutboundConnection(LocalOutboundConnection value) {
        this.subresources.localOutboundConnections.add(value);
        return (T)this;
    }

    public T localOutboundConnection(String childKey, LocalOutboundConnectionConsumer consumer) {
        LocalOutboundConnection child = new LocalOutboundConnection(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.localOutboundConnection(child);
        return (T)this;
    }

    public T localOutboundConnection(String childKey) {
        this.localOutboundConnection(childKey, null);
        return (T)this;
    }

    public T localOutboundConnection(LocalOutboundConnectionSupplier supplier) {
        this.localOutboundConnection(supplier.get());
        return (T)this;
    }

    public T remoteOutboundConnections(List<RemoteOutboundConnection> value) {
        this.subresources.remoteOutboundConnections = value;
        return (T)this;
    }

    public T remoteOutboundConnection(RemoteOutboundConnection value) {
        this.subresources.remoteOutboundConnections.add(value);
        return (T)this;
    }

    public T remoteOutboundConnection(String childKey, RemoteOutboundConnectionConsumer consumer) {
        RemoteOutboundConnection child = new RemoteOutboundConnection(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.remoteOutboundConnection(child);
        return (T)this;
    }

    public T remoteOutboundConnection(String childKey) {
        this.remoteOutboundConnection(childKey, null);
        return (T)this;
    }

    public T remoteOutboundConnection(RemoteOutboundConnectionSupplier supplier) {
        this.remoteOutboundConnection(supplier.get());
        return (T)this;
    }

    public T endpointConfiguration(EndpointConfiguration value) {
        this.subresources.endpointConfiguration = value;
        return (T)this;
    }

    public T endpointConfiguration(EndpointConfigurationConsumer consumer) {
        EndpointConfiguration child = new EndpointConfiguration();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.endpointConfiguration = child;
        return (T)this;
    }

    public T endpointConfiguration() {
        EndpointConfiguration child = new EndpointConfiguration();
        this.subresources.endpointConfiguration = child;
        return (T)this;
    }

    public T endpointConfiguration(EndpointConfigurationSupplier supplier) {
        this.subresources.endpointConfiguration = supplier.get();
        return (T)this;
    }

    public static class RemotingResources {
        private List<HTTPConnector> httpConnectors = new ArrayList<HTTPConnector>();
        private List<Connector> connectors = new ArrayList<Connector>();
        private List<OutboundConnection> outboundConnections = new ArrayList<OutboundConnection>();
        private List<LocalOutboundConnection> localOutboundConnections = new ArrayList<LocalOutboundConnection>();
        private List<RemoteOutboundConnection> remoteOutboundConnections = new ArrayList<RemoteOutboundConnection>();
        private EndpointConfiguration endpointConfiguration;

        @Subresource
        public List<HTTPConnector> httpConnectors() {
            return this.httpConnectors;
        }

        public HTTPConnector httpConnector(String key) {
            return this.httpConnectors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Connector> connectors() {
            return this.connectors;
        }

        public Connector connector(String key) {
            return this.connectors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<OutboundConnection> outboundConnections() {
            return this.outboundConnections;
        }

        public OutboundConnection outboundConnection(String key) {
            return this.outboundConnections.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<LocalOutboundConnection> localOutboundConnections() {
            return this.localOutboundConnections;
        }

        public LocalOutboundConnection localOutboundConnection(String key) {
            return this.localOutboundConnections.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<RemoteOutboundConnection> remoteOutboundConnections() {
            return this.remoteOutboundConnections;
        }

        public RemoteOutboundConnection remoteOutboundConnection(String key) {
            return this.remoteOutboundConnections.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public EndpointConfiguration endpointConfiguration() {
            return this.endpointConfiguration;
        }
    }
}

