/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.infinispan.cache_container.Backup;
import org.wildfly.swarm.config.infinispan.cache_container.BackupConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.BackupSupplier;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Addresses(value={"/subsystem=infinispan/cache-container=*/replicated-cache=*/component=backups", "/subsystem=infinispan/cache-container=*/distributed-cache=*/component=backups"})
@ResourceType(value="component")
@Implicit
public class BackupsComponent<T extends BackupsComponent<T>>
extends HashMap {
    private String key = "backups";
    private PropertyChangeSupport pcs;
    private BackupsComponentResources subresources = new BackupsComponentResources();

    public BackupsComponent() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public BackupsComponentResources subresources() {
        return this.subresources;
    }

    public T backups(List<Backup> value) {
        this.subresources.backups = value;
        return (T)this;
    }

    public T backup(Backup value) {
        this.subresources.backups.add(value);
        return (T)this;
    }

    public T backup(String childKey, BackupConsumer consumer) {
        Backup child = new Backup(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.backup(child);
        return (T)this;
    }

    public T backup(String childKey) {
        this.backup(childKey, null);
        return (T)this;
    }

    public T backup(BackupSupplier supplier) {
        this.backup(supplier.get());
        return (T)this;
    }

    public static class BackupsComponentResources {
        private List<Backup> backups = new ArrayList<Backup>();

        @Subresource
        public List<Backup> backups() {
            return this.backups;
        }

        public Backup backup(String key) {
            return this.backups.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

