package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.ejb3.service.FileDataStoreConsumer;
import org.wildfly.swarm.config.ejb3.service.FileDataStoreSupplier;
import org.wildfly.swarm.config.ejb3.service.FileDataStore;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.ejb3.service.DatabaseDataStoreConsumer;
import org.wildfly.swarm.config.ejb3.service.DatabaseDataStoreSupplier;
import org.wildfly.swarm.config.ejb3.service.DatabaseDataStore;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The EJB timer service
 */
@Address("/subsystem=ejb3/service=timer-service")
@ResourceType("service")
@Implicit
public class TimerService<T extends TimerService<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private TimerServiceResources subresources = new TimerServiceResources();
	private String defaultDataStore;
	private String threadPoolName;

	public TimerService() {
		super();
		this.key = "timer-service";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public TimerServiceResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all FileDataStore objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of FileDataStore objects.
	 */
	@SuppressWarnings("unchecked")
	public T fileDataStores(java.util.List<FileDataStore> value) {
		this.subresources.fileDataStores = value;
		return (T) this;
	}

	/**
	 * Add the FileDataStore object to the list of subresources
	 * 
	 * @param value
	 *            The FileDataStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T fileDataStore(FileDataStore value) {
		this.subresources.fileDataStores.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a FileDataStore object to the list of subresources
	 * 
	 * @param key
	 *            The key for the FileDataStore resource
	 * @param config
	 *            The FileDataStoreConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T fileDataStore(java.lang.String childKey,
			FileDataStoreConsumer consumer) {
		FileDataStore<? extends FileDataStore> child = new FileDataStore<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		fileDataStore(child);
		return (T) this;
	}

	/**
	 * Create and configure a FileDataStore object to the list of subresources
	 * 
	 * @param key
	 *            The key for the FileDataStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T fileDataStore(java.lang.String childKey) {
		fileDataStore(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied FileDataStore object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T fileDataStore(FileDataStoreSupplier supplier) {
		fileDataStore(supplier.get());
		return (T) this;
	}

	/**
	 * Add all DatabaseDataStore objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of DatabaseDataStore objects.
	 */
	@SuppressWarnings("unchecked")
	public T databaseDataStores(java.util.List<DatabaseDataStore> value) {
		this.subresources.databaseDataStores = value;
		return (T) this;
	}

	/**
	 * Add the DatabaseDataStore object to the list of subresources
	 * 
	 * @param value
	 *            The DatabaseDataStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T databaseDataStore(DatabaseDataStore value) {
		this.subresources.databaseDataStores.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a DatabaseDataStore object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the DatabaseDataStore resource
	 * @param config
	 *            The DatabaseDataStoreConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T databaseDataStore(java.lang.String childKey,
			DatabaseDataStoreConsumer consumer) {
		DatabaseDataStore<? extends DatabaseDataStore> child = new DatabaseDataStore<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		databaseDataStore(child);
		return (T) this;
	}

	/**
	 * Create and configure a DatabaseDataStore object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the DatabaseDataStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T databaseDataStore(java.lang.String childKey) {
		databaseDataStore(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied DatabaseDataStore object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T databaseDataStore(DatabaseDataStoreSupplier supplier) {
		databaseDataStore(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for TimerService
	 */
	public static class TimerServiceResources {
		/**
		 * A JVM local file store that stores persistent EJB timers
		 */
		@SubresourceInfo("fileDataStore")
		private List<FileDataStore> fileDataStores = new java.util.ArrayList<>();
		/**
		 * An database based store for persistent EJB timers.
		 */
		@SubresourceInfo("databaseDataStore")
		private List<DatabaseDataStore> databaseDataStores = new java.util.ArrayList<>();

		/**
		 * Get the list of FileDataStore resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<FileDataStore> fileDataStores() {
			return this.fileDataStores;
		}

		public FileDataStore fileDataStore(java.lang.String key) {
			return this.fileDataStores.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of DatabaseDataStore resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<DatabaseDataStore> databaseDataStores() {
			return this.databaseDataStores;
		}

		public DatabaseDataStore databaseDataStore(java.lang.String key) {
			return this.databaseDataStores.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * The default data store used for persistent timers
	 */
	@ModelNodeBinding(detypedName = "default-data-store")
	public String defaultDataStore() {
		return this.defaultDataStore;
	}

	/**
	 * The default data store used for persistent timers
	 */
	@SuppressWarnings("unchecked")
	public T defaultDataStore(java.lang.String value) {
		Object oldValue = this.defaultDataStore;
		this.defaultDataStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultDataStore", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the thread pool used to run timer service invocations
	 */
	@ModelNodeBinding(detypedName = "thread-pool-name")
	public String threadPoolName() {
		return this.threadPoolName;
	}

	/**
	 * The name of the thread pool used to run timer service invocations
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolName(java.lang.String value) {
		Object oldValue = this.threadPoolName;
		this.threadPoolName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("threadPoolName", oldValue, value);
		return (T) this;
	}
}