package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Archive validation for resource adapters
 */
@Address("/subsystem=jca/archive-validation=archive-validation")
@ResourceType("archive-validation")
@Implicit
public class ArchiveValidation<T extends ArchiveValidation<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean enabled;
	private Boolean failOnError;
	private Boolean failOnWarn;

	public ArchiveValidation() {
		super();
		this.key = "archive-validation";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Specify whether archive validation is enabled
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * Specify whether archive validation is enabled
	 */
	@SuppressWarnings("unchecked")
	public T enabled(java.lang.Boolean value) {
		Object oldValue = this.enabled;
		this.enabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Should an archive validation error report fail the deployment
	 */
	@ModelNodeBinding(detypedName = "fail-on-error")
	public Boolean failOnError() {
		return this.failOnError;
	}

	/**
	 * Should an archive validation error report fail the deployment
	 */
	@SuppressWarnings("unchecked")
	public T failOnError(java.lang.Boolean value) {
		Object oldValue = this.failOnError;
		this.failOnError = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("failOnError", oldValue, value);
		return (T) this;
	}

	/**
	 * Should an archive validation warning report fail the deployment
	 */
	@ModelNodeBinding(detypedName = "fail-on-warn")
	public Boolean failOnWarn() {
		return this.failOnWarn;
	}

	/**
	 * Should an archive validation warning report fail the deployment
	 */
	@SuppressWarnings("unchecked")
	public T failOnWarn(java.lang.Boolean value) {
		Object oldValue = this.failOnWarn;
		this.failOnWarn = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("failOnWarn", oldValue, value);
		return (T) this;
	}
}