package org.wildfly.swarm.config.undertow.server.host;

import org.wildfly.swarm.config.undertow.server.host.AccessLogSetting;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AccessLogSettingConsumer<T extends AccessLogSetting<T>> {

	/**
	 * Configure a pre-constructed instance of AccessLogSetting resource
	 * 
	 * @parameter Instance of AccessLogSetting to configure
	 * @return nothing
	 */
	void accept(T value);

	default AccessLogSettingConsumer<T> andThen(
			AccessLogSettingConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}