/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.transactions.CommitMarkableResource;
import org.wildfly.swarm.config.transactions.CommitMarkableResourceConsumer;
import org.wildfly.swarm.config.transactions.CommitMarkableResourceSupplier;
import org.wildfly.swarm.config.transactions.LogStore;
import org.wildfly.swarm.config.transactions.LogStoreConsumer;
import org.wildfly.swarm.config.transactions.LogStoreSupplier;

@Address(value="/subsystem=transactions")
@ResourceType(value="subsystem")
@Implicit
public class Transactions<T extends Transactions<T>>
extends HashMap
implements Keyed {
    private String key = "transactions";
    private PropertyChangeSupport pcs;
    private TransactionsResources subresources = new TransactionsResources();
    private Integer defaultTimeout;
    private Boolean enableTsmStatus;
    private Boolean jdbcActionStoreDropTable;
    private String jdbcActionStoreTablePrefix;
    private Boolean jdbcCommunicationStoreDropTable;
    private String jdbcCommunicationStoreTablePrefix;
    private Boolean jdbcStateStoreDropTable;
    private String jdbcStateStoreTablePrefix;
    private String jdbcStoreDatasource;
    private Boolean journalStoreEnableAsyncIo;
    private Boolean jts;
    private String nodeIdentifier;
    private Long numberOfAbortedTransactions;
    private Long numberOfApplicationRollbacks;
    private Long numberOfCommittedTransactions;
    private Long numberOfHeuristics;
    private Long numberOfInflightTransactions;
    private Long numberOfNestedTransactions;
    private Long numberOfResourceRollbacks;
    private Long numberOfTimedOutTransactions;
    private Long numberOfTransactions;
    private String objectStorePath;
    private String objectStoreRelativeTo;
    private String processIdSocketBinding;
    private Integer processIdSocketMaxPorts;
    private Boolean processIdUuid;
    private Boolean recoveryListener;
    private String socketBinding;
    private Boolean statisticsEnabled;
    private String statusSocketBinding;
    private Boolean useJdbcStore;
    private Boolean useJournalStore;

    public Transactions() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public TransactionsResources subresources() {
        return this.subresources;
    }

    public T commitMarkableResources(List<CommitMarkableResource> value) {
        this.subresources.commitMarkableResources = value;
        return (T)this;
    }

    public T commitMarkableResource(CommitMarkableResource value) {
        this.subresources.commitMarkableResources.add(value);
        return (T)this;
    }

    public T commitMarkableResource(String childKey, CommitMarkableResourceConsumer consumer) {
        CommitMarkableResource child = new CommitMarkableResource(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.commitMarkableResource(child);
        return (T)this;
    }

    public T commitMarkableResource(String childKey) {
        this.commitMarkableResource(childKey, null);
        return (T)this;
    }

    public T commitMarkableResource(CommitMarkableResourceSupplier supplier) {
        this.commitMarkableResource(supplier.get());
        return (T)this;
    }

    public T logStore(LogStore value) {
        this.subresources.logStore = value;
        return (T)this;
    }

    public T logStore(LogStoreConsumer consumer) {
        LogStore child = new LogStore();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.logStore = child;
        return (T)this;
    }

    public T logStore() {
        LogStore child = new LogStore();
        this.subresources.logStore = child;
        return (T)this;
    }

    public T logStore(LogStoreSupplier supplier) {
        this.subresources.logStore = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-timeout")
    public Integer defaultTimeout() {
        return this.defaultTimeout;
    }

    public T defaultTimeout(Integer value) {
        Integer oldValue = this.defaultTimeout;
        this.defaultTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-tsm-status")
    public Boolean enableTsmStatus() {
        return this.enableTsmStatus;
    }

    public T enableTsmStatus(Boolean value) {
        Boolean oldValue = this.enableTsmStatus;
        this.enableTsmStatus = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableTsmStatus", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-action-store-drop-table")
    public Boolean jdbcActionStoreDropTable() {
        return this.jdbcActionStoreDropTable;
    }

    public T jdbcActionStoreDropTable(Boolean value) {
        Boolean oldValue = this.jdbcActionStoreDropTable;
        this.jdbcActionStoreDropTable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcActionStoreDropTable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-action-store-table-prefix")
    public String jdbcActionStoreTablePrefix() {
        return this.jdbcActionStoreTablePrefix;
    }

    public T jdbcActionStoreTablePrefix(String value) {
        String oldValue = this.jdbcActionStoreTablePrefix;
        this.jdbcActionStoreTablePrefix = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcActionStoreTablePrefix", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-communication-store-drop-table")
    public Boolean jdbcCommunicationStoreDropTable() {
        return this.jdbcCommunicationStoreDropTable;
    }

    public T jdbcCommunicationStoreDropTable(Boolean value) {
        Boolean oldValue = this.jdbcCommunicationStoreDropTable;
        this.jdbcCommunicationStoreDropTable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcCommunicationStoreDropTable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-communication-store-table-prefix")
    public String jdbcCommunicationStoreTablePrefix() {
        return this.jdbcCommunicationStoreTablePrefix;
    }

    public T jdbcCommunicationStoreTablePrefix(String value) {
        String oldValue = this.jdbcCommunicationStoreTablePrefix;
        this.jdbcCommunicationStoreTablePrefix = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcCommunicationStoreTablePrefix", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-state-store-drop-table")
    public Boolean jdbcStateStoreDropTable() {
        return this.jdbcStateStoreDropTable;
    }

    public T jdbcStateStoreDropTable(Boolean value) {
        Boolean oldValue = this.jdbcStateStoreDropTable;
        this.jdbcStateStoreDropTable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcStateStoreDropTable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-state-store-table-prefix")
    public String jdbcStateStoreTablePrefix() {
        return this.jdbcStateStoreTablePrefix;
    }

    public T jdbcStateStoreTablePrefix(String value) {
        String oldValue = this.jdbcStateStoreTablePrefix;
        this.jdbcStateStoreTablePrefix = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcStateStoreTablePrefix", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-store-datasource")
    public String jdbcStoreDatasource() {
        return this.jdbcStoreDatasource;
    }

    public T jdbcStoreDatasource(String value) {
        String oldValue = this.jdbcStoreDatasource;
        this.jdbcStoreDatasource = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcStoreDatasource", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-store-enable-async-io")
    public Boolean journalStoreEnableAsyncIo() {
        return this.journalStoreEnableAsyncIo;
    }

    public T journalStoreEnableAsyncIo(Boolean value) {
        Boolean oldValue = this.journalStoreEnableAsyncIo;
        this.journalStoreEnableAsyncIo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalStoreEnableAsyncIo", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jts")
    public Boolean jts() {
        return this.jts;
    }

    public T jts(Boolean value) {
        Boolean oldValue = this.jts;
        this.jts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="node-identifier")
    public String nodeIdentifier() {
        return this.nodeIdentifier;
    }

    public T nodeIdentifier(String value) {
        String oldValue = this.nodeIdentifier;
        this.nodeIdentifier = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("nodeIdentifier", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-aborted-transactions")
    public Long numberOfAbortedTransactions() {
        return this.numberOfAbortedTransactions;
    }

    public T numberOfAbortedTransactions(Long value) {
        Long oldValue = this.numberOfAbortedTransactions;
        this.numberOfAbortedTransactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfAbortedTransactions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-application-rollbacks")
    public Long numberOfApplicationRollbacks() {
        return this.numberOfApplicationRollbacks;
    }

    public T numberOfApplicationRollbacks(Long value) {
        Long oldValue = this.numberOfApplicationRollbacks;
        this.numberOfApplicationRollbacks = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfApplicationRollbacks", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-committed-transactions")
    public Long numberOfCommittedTransactions() {
        return this.numberOfCommittedTransactions;
    }

    public T numberOfCommittedTransactions(Long value) {
        Long oldValue = this.numberOfCommittedTransactions;
        this.numberOfCommittedTransactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfCommittedTransactions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-heuristics")
    public Long numberOfHeuristics() {
        return this.numberOfHeuristics;
    }

    public T numberOfHeuristics(Long value) {
        Long oldValue = this.numberOfHeuristics;
        this.numberOfHeuristics = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfHeuristics", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-inflight-transactions")
    public Long numberOfInflightTransactions() {
        return this.numberOfInflightTransactions;
    }

    public T numberOfInflightTransactions(Long value) {
        Long oldValue = this.numberOfInflightTransactions;
        this.numberOfInflightTransactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfInflightTransactions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-nested-transactions")
    public Long numberOfNestedTransactions() {
        return this.numberOfNestedTransactions;
    }

    public T numberOfNestedTransactions(Long value) {
        Long oldValue = this.numberOfNestedTransactions;
        this.numberOfNestedTransactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfNestedTransactions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-resource-rollbacks")
    public Long numberOfResourceRollbacks() {
        return this.numberOfResourceRollbacks;
    }

    public T numberOfResourceRollbacks(Long value) {
        Long oldValue = this.numberOfResourceRollbacks;
        this.numberOfResourceRollbacks = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfResourceRollbacks", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-timed-out-transactions")
    public Long numberOfTimedOutTransactions() {
        return this.numberOfTimedOutTransactions;
    }

    public T numberOfTimedOutTransactions(Long value) {
        Long oldValue = this.numberOfTimedOutTransactions;
        this.numberOfTimedOutTransactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfTimedOutTransactions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-transactions")
    public Long numberOfTransactions() {
        return this.numberOfTransactions;
    }

    public T numberOfTransactions(Long value) {
        Long oldValue = this.numberOfTransactions;
        this.numberOfTransactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfTransactions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="object-store-path")
    public String objectStorePath() {
        return this.objectStorePath;
    }

    public T objectStorePath(String value) {
        String oldValue = this.objectStorePath;
        this.objectStorePath = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("objectStorePath", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="object-store-relative-to")
    public String objectStoreRelativeTo() {
        return this.objectStoreRelativeTo;
    }

    public T objectStoreRelativeTo(String value) {
        String oldValue = this.objectStoreRelativeTo;
        this.objectStoreRelativeTo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("objectStoreRelativeTo", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="process-id-socket-binding")
    public String processIdSocketBinding() {
        return this.processIdSocketBinding;
    }

    public T processIdSocketBinding(String value) {
        String oldValue = this.processIdSocketBinding;
        this.processIdSocketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("processIdSocketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="process-id-socket-max-ports")
    public Integer processIdSocketMaxPorts() {
        return this.processIdSocketMaxPorts;
    }

    public T processIdSocketMaxPorts(Integer value) {
        Integer oldValue = this.processIdSocketMaxPorts;
        this.processIdSocketMaxPorts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("processIdSocketMaxPorts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="process-id-uuid")
    public Boolean processIdUuid() {
        return this.processIdUuid;
    }

    public T processIdUuid(Boolean value) {
        Boolean oldValue = this.processIdUuid;
        this.processIdUuid = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("processIdUuid", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-listener")
    public Boolean recoveryListener() {
        return this.recoveryListener;
    }

    public T recoveryListener(Boolean value) {
        Boolean oldValue = this.recoveryListener;
        this.recoveryListener = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryListener", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-binding")
    public String socketBinding() {
        return this.socketBinding;
    }

    public T socketBinding(String value) {
        String oldValue = this.socketBinding;
        this.socketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        Boolean oldValue = this.statisticsEnabled;
        this.statisticsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="status-socket-binding")
    public String statusSocketBinding() {
        return this.statusSocketBinding;
    }

    public T statusSocketBinding(String value) {
        String oldValue = this.statusSocketBinding;
        this.statusSocketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statusSocketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-jdbc-store")
    public Boolean useJdbcStore() {
        return this.useJdbcStore;
    }

    public T useJdbcStore(Boolean value) {
        Boolean oldValue = this.useJdbcStore;
        this.useJdbcStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useJdbcStore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-journal-store")
    public Boolean useJournalStore() {
        return this.useJournalStore;
    }

    public T useJournalStore(Boolean value) {
        Boolean oldValue = this.useJournalStore;
        this.useJournalStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useJournalStore", oldValue, value);
        }
        return (T)this;
    }

    public static class TransactionsResources {
        @SubresourceInfo(value="commitMarkableResource")
        private List<CommitMarkableResource> commitMarkableResources = new ArrayList<CommitMarkableResource>();
        private LogStore logStore;

        @Subresource
        public List<CommitMarkableResource> commitMarkableResources() {
            return this.commitMarkableResources;
        }

        public CommitMarkableResource commitMarkableResource(String key) {
            return this.commitMarkableResources.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public LogStore logStore() {
            return this.logStore;
        }
    }
}

