/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.access;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.management.access.role_mapping.Exclude;
import org.wildfly.swarm.config.management.access.role_mapping.ExcludeConsumer;
import org.wildfly.swarm.config.management.access.role_mapping.ExcludeSupplier;
import org.wildfly.swarm.config.management.access.role_mapping.Include;
import org.wildfly.swarm.config.management.access.role_mapping.IncludeConsumer;
import org.wildfly.swarm.config.management.access.role_mapping.IncludeSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/core-service=management/access=authorization/role-mapping=*")
@ResourceType(value="role-mapping")
public class RoleMapping<T extends RoleMapping<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private RoleMappingResources subresources = new RoleMappingResources();
    private Boolean includeAll;

    public RoleMapping(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public RoleMappingResources subresources() {
        return this.subresources;
    }

    public T includes(List<Include> value) {
        this.subresources.includes = value;
        return (T)this;
    }

    public T include(Include value) {
        this.subresources.includes.add(value);
        return (T)this;
    }

    public T include(String childKey, IncludeConsumer consumer) {
        Include child = new Include(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.include(child);
        return (T)this;
    }

    public T include(String childKey) {
        this.include(childKey, null);
        return (T)this;
    }

    public T include(IncludeSupplier supplier) {
        this.include(supplier.get());
        return (T)this;
    }

    public T excludes(List<Exclude> value) {
        this.subresources.excludes = value;
        return (T)this;
    }

    public T exclude(Exclude value) {
        this.subresources.excludes.add(value);
        return (T)this;
    }

    public T exclude(String childKey, ExcludeConsumer consumer) {
        Exclude child = new Exclude(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.exclude(child);
        return (T)this;
    }

    public T exclude(String childKey) {
        this.exclude(childKey, null);
        return (T)this;
    }

    public T exclude(ExcludeSupplier supplier) {
        this.exclude(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="include-all")
    public Boolean includeAll() {
        return this.includeAll;
    }

    public T includeAll(Boolean value) {
        Boolean oldValue = this.includeAll;
        this.includeAll = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("includeAll", oldValue, value);
        }
        return (T)this;
    }

    public static class RoleMappingResources {
        @SubresourceInfo(value="include")
        private List<Include> includes = new ArrayList<Include>();
        @SubresourceInfo(value="exclude")
        private List<Exclude> excludes = new ArrayList<Exclude>();

        @Subresource
        public List<Include> includes() {
            return this.includes;
        }

        public Include include(String key) {
            return this.includes.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Exclude> excludes() {
            return this.excludes;
        }

        public Exclude exclude(String key) {
            return this.excludes.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

