/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.security_realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.management.security_realm.server_identity.Keytab;
import org.wildfly.swarm.config.management.security_realm.server_identity.KeytabConsumer;
import org.wildfly.swarm.config.management.security_realm.server_identity.KeytabSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/core-service=management/security-realm=*/server-identity=kerberos")
@ResourceType(value="server-identity")
@Implicit
public class KerberosServerIdentity<T extends KerberosServerIdentity<T>>
extends HashMap
implements Keyed {
    private String key = "kerberos";
    private PropertyChangeSupport pcs;
    private KerberosServerIdentityResources subresources = new KerberosServerIdentityResources();

    public KerberosServerIdentity() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public KerberosServerIdentityResources subresources() {
        return this.subresources;
    }

    public T keytabs(List<Keytab> value) {
        this.subresources.keytabs = value;
        return (T)this;
    }

    public T keytab(Keytab value) {
        this.subresources.keytabs.add(value);
        return (T)this;
    }

    public T keytab(String childKey, KeytabConsumer consumer) {
        Keytab child = new Keytab(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.keytab(child);
        return (T)this;
    }

    public T keytab(String childKey) {
        this.keytab(childKey, null);
        return (T)this;
    }

    public T keytab(KeytabSupplier supplier) {
        this.keytab(supplier.get());
        return (T)this;
    }

    public static class KerberosServerIdentityResources {
        @SubresourceInfo(value="keytab")
        private List<Keytab> keytabs = new ArrayList<Keytab>();

        @Subresource
        public List<Keytab> keytabs() {
            return this.keytabs;
        }

        public Keytab keytab(String key) {
            return this.keytabs.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

