/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security.security_domain;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.security.security_domain.authentication.AuthModule;
import org.wildfly.swarm.config.security.security_domain.authentication.AuthModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.authentication.AuthModuleSupplier;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStackConsumer;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStackSupplier;

@Address(value="/subsystem=security/security-domain=*/authentication=jaspi")
@ResourceType(value="authentication")
@Implicit
public class JaspiAuthentication<T extends JaspiAuthentication<T>>
extends HashMap
implements Keyed {
    private String key = "jaspi";
    private PropertyChangeSupport pcs;
    private JaspiAuthenticationResources subresources = new JaspiAuthenticationResources();

    public JaspiAuthentication() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public JaspiAuthenticationResources subresources() {
        return this.subresources;
    }

    public T loginModuleStacks(List<LoginModuleStack> value) {
        this.subresources.loginModuleStacks = value;
        return (T)this;
    }

    public T loginModuleStack(LoginModuleStack value) {
        this.subresources.loginModuleStacks.add(value);
        return (T)this;
    }

    public T loginModuleStack(String childKey, LoginModuleStackConsumer consumer) {
        LoginModuleStack child = new LoginModuleStack(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.loginModuleStack(child);
        return (T)this;
    }

    public T loginModuleStack(String childKey) {
        this.loginModuleStack(childKey, null);
        return (T)this;
    }

    public T loginModuleStack(LoginModuleStackSupplier supplier) {
        this.loginModuleStack(supplier.get());
        return (T)this;
    }

    public T authModules(List<AuthModule> value) {
        this.subresources.authModules = value;
        return (T)this;
    }

    public T authModule(AuthModule value) {
        this.subresources.authModules.add(value);
        return (T)this;
    }

    public T authModule(String childKey, AuthModuleConsumer consumer) {
        AuthModule child = new AuthModule(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.authModule(child);
        return (T)this;
    }

    public T authModule(String childKey) {
        this.authModule(childKey, null);
        return (T)this;
    }

    public T authModule(AuthModuleSupplier supplier) {
        this.authModule(supplier.get());
        return (T)this;
    }

    public static class JaspiAuthenticationResources {
        @SubresourceInfo(value="loginModuleStack")
        private List<LoginModuleStack> loginModuleStacks = new ArrayList<LoginModuleStack>();
        @SubresourceInfo(value="authModule")
        private List<AuthModule> authModules = new ArrayList<AuthModule>();

        @Subresource
        public List<LoginModuleStack> loginModuleStacks() {
            return this.loginModuleStacks;
        }

        public LoginModuleStack loginModuleStack(String key) {
            return this.loginModuleStacks.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<AuthModule> authModules() {
            return this.authModules;
        }

        public AuthModule authModule(String key) {
            return this.authModules.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

