package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The description of the transport used by this cache container
 */
@Address("/subsystem=infinispan/cache-container=*/transport=jgroups")
@ResourceType("transport")
@Implicit
public class JGroupsTransport<T extends JGroupsTransport<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private String channel;
	private Long lockTimeout;

	public JGroupsTransport() {
		super();
		this.key = "jgroups";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The channel of this cache container's transport.
	 */
	@ModelNodeBinding(detypedName = "channel")
	public String channel() {
		return this.channel;
	}

	/**
	 * The channel of this cache container's transport.
	 */
	@SuppressWarnings("unchecked")
	public T channel(java.lang.String value) {
		Object oldValue = this.channel;
		this.channel = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("channel", oldValue, value);
		return (T) this;
	}

	/**
	 * The timeout for locks for the transport
	 */
	@ModelNodeBinding(detypedName = "lock-timeout")
	public Long lockTimeout() {
		return this.lockTimeout;
	}

	/**
	 * The timeout for locks for the transport
	 */
	@SuppressWarnings("unchecked")
	public T lockTimeout(java.lang.Long value) {
		Object oldValue = this.lockTimeout;
		this.lockTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("lockTimeout", oldValue, value);
		return (T) this;
	}
}