package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.runtime.Addresses;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * A thread pool executor with a bounded queue where threads submittings tasks
 * will not block. Such a thread pool has a core and maximum size and a
 * specified queue length. When a task is submitted, if the number of running
 * threads is less than the core size, a new thread is created. Otherwise, if
 * there is room in the queue, the task is enqueued. Otherwise, if the number of
 * running threads is less than the maximum size, a new thread is created.
 * Otherwise, the task is handed off to the designated handoff executor, if one
 * is specified. Otherwise, the task is discarded.
 */
@Addresses({"/subsystem=jca/distributed-workmanager=*/long-running-threads=*",
		"/subsystem=jca/workmanager=*/long-running-threads=*"})
@ResourceType("long-running-threads")
public class LongRunningThreads<T extends LongRunningThreads<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean allowCoreTimeout;
	private Integer coreThreads;
	private Integer currentThreadCount;
	private String handoffExecutor;
	private Map keepaliveTime;
	private Integer largestThreadCount;
	private Integer maxThreads;
	private String name;
	private Integer queueLength;
	private Integer queueSize;
	private Integer rejectedCount;
	private String threadFactory;

	public LongRunningThreads(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Whether core threads may time out.
	 */
	@ModelNodeBinding(detypedName = "allow-core-timeout")
	public Boolean allowCoreTimeout() {
		return this.allowCoreTimeout;
	}

	/**
	 * Whether core threads may time out.
	 */
	@SuppressWarnings("unchecked")
	public T allowCoreTimeout(java.lang.Boolean value) {
		Object oldValue = this.allowCoreTimeout;
		this.allowCoreTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowCoreTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If
	 * undefined, the core thread pool size is the same as the maximum thread
	 * pool size.
	 */
	@ModelNodeBinding(detypedName = "core-threads")
	public Integer coreThreads() {
		return this.coreThreads;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If
	 * undefined, the core thread pool size is the same as the maximum thread
	 * pool size.
	 */
	@SuppressWarnings("unchecked")
	public T coreThreads(java.lang.Integer value) {
		Object oldValue = this.coreThreads;
		this.coreThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("coreThreads", oldValue, value);
		return (T) this;
	}

	/**
	 * The current number of threads in the pool.
	 */
	@ModelNodeBinding(detypedName = "current-thread-count")
	public Integer currentThreadCount() {
		return this.currentThreadCount;
	}

	/**
	 * The current number of threads in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T currentThreadCount(java.lang.Integer value) {
		Object oldValue = this.currentThreadCount;
		this.currentThreadCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("currentThreadCount", oldValue, value);
		return (T) this;
	}

	/**
	 * An executor to delegate tasks to in the event that a task cannot be
	 * accepted. If not specified, tasks that cannot be accepted will be
	 * silently discarded.
	 */
	@ModelNodeBinding(detypedName = "handoff-executor")
	public String handoffExecutor() {
		return this.handoffExecutor;
	}

	/**
	 * An executor to delegate tasks to in the event that a task cannot be
	 * accepted. If not specified, tasks that cannot be accepted will be
	 * silently discarded.
	 */
	@SuppressWarnings("unchecked")
	public T handoffExecutor(java.lang.String value) {
		Object oldValue = this.handoffExecutor;
		this.handoffExecutor = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("handoffExecutor", oldValue, value);
		return (T) this;
	}

	/**
	 * Used to specify the amount of time that pool threads should be kept
	 * running when idle; if not specified, threads will run until the executor
	 * is shut down.
	 */
	@ModelNodeBinding(detypedName = "keepalive-time")
	public Map keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * Used to specify the amount of time that pool threads should be kept
	 * running when idle; if not specified, threads will run until the executor
	 * is shut down.
	 */
	@SuppressWarnings("unchecked")
	public T keepaliveTime(java.util.Map value) {
		Object oldValue = this.keepaliveTime;
		this.keepaliveTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keepaliveTime", oldValue, value);
		return (T) this;
	}

	/**
	 * Used to specify the amount of time that pool threads should be kept
	 * running when idle; if not specified, threads will run until the executor
	 * is shut down.
	 */
	@SuppressWarnings("unchecked")
	public T keepaliveTime(java.lang.String key, java.lang.Object value) {
		if (this.keepaliveTime == null) {
			this.keepaliveTime = new java.util.HashMap<>();
		}
		this.keepaliveTime.put(key, value);
		return (T) this;
	}

	/**
	 * The largest number of threads that have ever simultaneously been in the
	 * pool.
	 */
	@ModelNodeBinding(detypedName = "largest-thread-count")
	public Integer largestThreadCount() {
		return this.largestThreadCount;
	}

	/**
	 * The largest number of threads that have ever simultaneously been in the
	 * pool.
	 */
	@SuppressWarnings("unchecked")
	public T largestThreadCount(java.lang.Integer value) {
		Object oldValue = this.largestThreadCount;
		this.largestThreadCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("largestThreadCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public T maxThreads(java.lang.Integer value) {
		Object oldValue = this.maxThreads;
		this.maxThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxThreads", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the thread pool.
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the thread pool.
	 */
	@SuppressWarnings("unchecked")
	public T name(java.lang.String value) {
		Object oldValue = this.name;
		this.name = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("name", oldValue, value);
		return (T) this;
	}

	/**
	 * The queue length.
	 */
	@ModelNodeBinding(detypedName = "queue-length")
	public Integer queueLength() {
		return this.queueLength;
	}

	/**
	 * The queue length.
	 */
	@SuppressWarnings("unchecked")
	public T queueLength(java.lang.Integer value) {
		Object oldValue = this.queueLength;
		this.queueLength = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queueLength", oldValue, value);
		return (T) this;
	}

	/**
	 * The queue size.
	 */
	@ModelNodeBinding(detypedName = "queue-size")
	public Integer queueSize() {
		return this.queueSize;
	}

	/**
	 * The queue size.
	 */
	@SuppressWarnings("unchecked")
	public T queueSize(java.lang.Integer value) {
		Object oldValue = this.queueSize;
		this.queueSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queueSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of tasks that have been passed to the handoff-executor (if one
	 * is specified) or discarded.
	 */
	@ModelNodeBinding(detypedName = "rejected-count")
	public Integer rejectedCount() {
		return this.rejectedCount;
	}

	/**
	 * The number of tasks that have been passed to the handoff-executor (if one
	 * is specified) or discarded.
	 */
	@SuppressWarnings("unchecked")
	public T rejectedCount(java.lang.Integer value) {
		Object oldValue = this.rejectedCount;
		this.rejectedCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("rejectedCount", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the name of a specific thread factory to use to create worker
	 * threads. If not defined an appropriate default thread factory will be
	 * used.
	 */
	@ModelNodeBinding(detypedName = "thread-factory")
	public String threadFactory() {
		return this.threadFactory;
	}

	/**
	 * Specifies the name of a specific thread factory to use to create worker
	 * threads. If not defined an appropriate default thread factory will be
	 * used.
	 */
	@SuppressWarnings("unchecked")
	public T threadFactory(java.lang.String value) {
		Object oldValue = this.threadFactory;
		this.threadFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("threadFactory", oldValue, value);
		return (T) this;
	}
}