package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.management.access.RoleMappingConsumer;
import org.wildfly.swarm.config.management.access.RoleMappingSupplier;
import org.wildfly.swarm.config.management.access.RoleMapping;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.management.access.VaultExpressionConstraint;
import org.wildfly.swarm.config.management.access.VaultExpressionConstraintConsumer;
import org.wildfly.swarm.config.management.access.VaultExpressionConstraintSupplier;
import org.wildfly.swarm.config.management.access.ApplicationClassificationConstraint;
import org.wildfly.swarm.config.management.access.ApplicationClassificationConstraintConsumer;
import org.wildfly.swarm.config.management.access.ApplicationClassificationConstraintSupplier;
import org.wildfly.swarm.config.management.access.SensitivityClassificationConstraint;
import org.wildfly.swarm.config.management.access.SensitivityClassificationConstraintConsumer;
import org.wildfly.swarm.config.management.access.SensitivityClassificationConstraintSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * The access control definitions defining the access management restrictions.
 */
@Address("/core-service=management/access=authorization")
@ResourceType("access")
@Implicit
public class AuthorizationAccess<T extends AuthorizationAccess<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private AuthorizationAccessResources subresources = new AuthorizationAccessResources();
	private List<String> allRoleNames;
	private PermissionCombinationPolicy permissionCombinationPolicy;
	private Provider provider;
	private List<String> standardRoleNames;

	public AuthorizationAccess() {
		super();
		this.key = "authorization";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public AuthorizationAccessResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all RoleMapping objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RoleMapping objects.
	 */
	@SuppressWarnings("unchecked")
	public T roleMappings(java.util.List<RoleMapping> value) {
		this.subresources.roleMappings = value;
		return (T) this;
	}

	/**
	 * Add the RoleMapping object to the list of subresources
	 * 
	 * @param value
	 *            The RoleMapping to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T roleMapping(RoleMapping value) {
		this.subresources.roleMappings.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RoleMapping object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RoleMapping resource
	 * @param config
	 *            The RoleMappingConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T roleMapping(java.lang.String childKey, RoleMappingConsumer consumer) {
		RoleMapping<? extends RoleMapping> child = new RoleMapping<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		roleMapping(child);
		return (T) this;
	}

	/**
	 * Create and configure a RoleMapping object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RoleMapping resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T roleMapping(java.lang.String childKey) {
		roleMapping(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RoleMapping object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T roleMapping(RoleMappingSupplier supplier) {
		roleMapping(supplier.get());
		return (T) this;
	}

	/**
	 * Configuration of whether vault expressions should be considered
	 * sensitive.
	 */
	@SuppressWarnings("unchecked")
	public T vaultExpressionConstraint(VaultExpressionConstraint value) {
		this.subresources.vaultExpressionConstraint = value;
		return (T) this;
	}

	/**
	 * Configuration of whether vault expressions should be considered
	 * sensitive.
	 */
	@SuppressWarnings("unchecked")
	public T vaultExpressionConstraint(
			VaultExpressionConstraintConsumer consumer) {
		VaultExpressionConstraint<? extends VaultExpressionConstraint> child = new VaultExpressionConstraint<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.vaultExpressionConstraint = child;
		return (T) this;
	}

	/**
	 * Configuration of whether vault expressions should be considered
	 * sensitive.
	 */
	@SuppressWarnings("unchecked")
	public T vaultExpressionConstraint() {
		VaultExpressionConstraint<? extends VaultExpressionConstraint> child = new VaultExpressionConstraint<>();
		this.subresources.vaultExpressionConstraint = child;
		return (T) this;
	}

	/**
	 * Configuration of whether vault expressions should be considered
	 * sensitive.
	 */
	@SuppressWarnings("unchecked")
	public T vaultExpressionConstraint(
			VaultExpressionConstraintSupplier supplier) {
		this.subresources.vaultExpressionConstraint = supplier.get();
		return (T) this;
	}

	/**
	 * Configuration of the application classification constraints.
	 */
	@SuppressWarnings("unchecked")
	public T applicationClassificationConstraint(
			ApplicationClassificationConstraint value) {
		this.subresources.applicationClassificationConstraint = value;
		return (T) this;
	}

	/**
	 * Configuration of the application classification constraints.
	 */
	@SuppressWarnings("unchecked")
	public T applicationClassificationConstraint(
			ApplicationClassificationConstraintConsumer consumer) {
		ApplicationClassificationConstraint<? extends ApplicationClassificationConstraint> child = new ApplicationClassificationConstraint<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.applicationClassificationConstraint = child;
		return (T) this;
	}

	/**
	 * Configuration of the application classification constraints.
	 */
	@SuppressWarnings("unchecked")
	public T applicationClassificationConstraint() {
		ApplicationClassificationConstraint<? extends ApplicationClassificationConstraint> child = new ApplicationClassificationConstraint<>();
		this.subresources.applicationClassificationConstraint = child;
		return (T) this;
	}

	/**
	 * Configuration of the application classification constraints.
	 */
	@SuppressWarnings("unchecked")
	public T applicationClassificationConstraint(
			ApplicationClassificationConstraintSupplier supplier) {
		this.subresources.applicationClassificationConstraint = supplier.get();
		return (T) this;
	}

	/**
	 * The sensitivity classification constraints.
	 */
	@SuppressWarnings("unchecked")
	public T sensitivityClassificationConstraint(
			SensitivityClassificationConstraint value) {
		this.subresources.sensitivityClassificationConstraint = value;
		return (T) this;
	}

	/**
	 * The sensitivity classification constraints.
	 */
	@SuppressWarnings("unchecked")
	public T sensitivityClassificationConstraint(
			SensitivityClassificationConstraintConsumer consumer) {
		SensitivityClassificationConstraint<? extends SensitivityClassificationConstraint> child = new SensitivityClassificationConstraint<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.sensitivityClassificationConstraint = child;
		return (T) this;
	}

	/**
	 * The sensitivity classification constraints.
	 */
	@SuppressWarnings("unchecked")
	public T sensitivityClassificationConstraint() {
		SensitivityClassificationConstraint<? extends SensitivityClassificationConstraint> child = new SensitivityClassificationConstraint<>();
		this.subresources.sensitivityClassificationConstraint = child;
		return (T) this;
	}

	/**
	 * The sensitivity classification constraints.
	 */
	@SuppressWarnings("unchecked")
	public T sensitivityClassificationConstraint(
			SensitivityClassificationConstraintSupplier supplier) {
		this.subresources.sensitivityClassificationConstraint = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for AuthorizationAccess
	 */
	public static class AuthorizationAccessResources {
		/**
		 * A mapping of users and groups to a specific role.
		 */
		@SubresourceInfo("roleMapping")
		private List<RoleMapping> roleMappings = new java.util.ArrayList<>();
		private VaultExpressionConstraint vaultExpressionConstraint;
		private ApplicationClassificationConstraint applicationClassificationConstraint;
		private SensitivityClassificationConstraint sensitivityClassificationConstraint;

		/**
		 * Get the list of RoleMapping resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RoleMapping> roleMappings() {
			return this.roleMappings;
		}

		public RoleMapping roleMapping(java.lang.String key) {
			return this.roleMappings.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Configuration of whether vault expressions should be considered
		 * sensitive.
		 */
		@Subresource
		public VaultExpressionConstraint vaultExpressionConstraint() {
			return this.vaultExpressionConstraint;
		}

		/**
		 * Configuration of the application classification constraints.
		 */
		@Subresource
		public ApplicationClassificationConstraint applicationClassificationConstraint() {
			return this.applicationClassificationConstraint;
		}

		/**
		 * The sensitivity classification constraints.
		 */
		@Subresource
		public SensitivityClassificationConstraint sensitivityClassificationConstraint() {
			return this.sensitivityClassificationConstraint;
		}
	}

	public static enum PermissionCombinationPolicy {
		PERMISSIVE("permissive"), REJECTING("rejecting");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		PermissionCombinationPolicy(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum Provider {
		SIMPLE("simple"), RBAC("rbac");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Provider(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The official names of all roles supported by the current management
	 * access control provider. This includes any standard roles as well as any
	 * user-defined roles.
	 */
	@ModelNodeBinding(detypedName = "all-role-names")
	public List<String> allRoleNames() {
		return this.allRoleNames;
	}

	/**
	 * The official names of all roles supported by the current management
	 * access control provider. This includes any standard roles as well as any
	 * user-defined roles.
	 */
	@SuppressWarnings("unchecked")
	public T allRoleNames(java.util.List<String> value) {
		Object oldValue = this.allRoleNames;
		this.allRoleNames = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allRoleNames", oldValue, value);
		return (T) this;
	}

	/**
	 * The official names of all roles supported by the current management
	 * access control provider. This includes any standard roles as well as any
	 * user-defined roles.
	 */
	@SuppressWarnings("unchecked")
	public T allRoleName(String value) {
		if (this.allRoleNames == null) {
			this.allRoleNames = new java.util.ArrayList<>();
		}
		this.allRoleNames.add(value);
		return (T) this;
	}

	/**
	 * The official names of all roles supported by the current management
	 * access control provider. This includes any standard roles as well as any
	 * user-defined roles.
	 */
	@SuppressWarnings("unchecked")
	public T allRoleNames(String... args) {
		allRoleNames(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The policy for combining access control permissions when the
	 * authorization policy grants the user more than one type of permission for
	 * a given action. In the standard role based authorization policy, this
	 * would occur when a user maps to multiple roles. The 'permissive' policy
	 * means if any of the permissions allow the action, the action is allowed.
	 * The 'rejecting' policy means the existence of multiple permissions should
	 * result in an error.
	 */
	@ModelNodeBinding(detypedName = "permission-combination-policy")
	public PermissionCombinationPolicy permissionCombinationPolicy() {
		return this.permissionCombinationPolicy;
	}

	/**
	 * The policy for combining access control permissions when the
	 * authorization policy grants the user more than one type of permission for
	 * a given action. In the standard role based authorization policy, this
	 * would occur when a user maps to multiple roles. The 'permissive' policy
	 * means if any of the permissions allow the action, the action is allowed.
	 * The 'rejecting' policy means the existence of multiple permissions should
	 * result in an error.
	 */
	@SuppressWarnings("unchecked")
	public T permissionCombinationPolicy(PermissionCombinationPolicy value) {
		Object oldValue = this.permissionCombinationPolicy;
		this.permissionCombinationPolicy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("permissionCombinationPolicy",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The provider to use for management access control decisions.
	 */
	@ModelNodeBinding(detypedName = "provider")
	public Provider provider() {
		return this.provider;
	}

	/**
	 * The provider to use for management access control decisions.
	 */
	@SuppressWarnings("unchecked")
	public T provider(Provider value) {
		Object oldValue = this.provider;
		this.provider = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("provider", oldValue, value);
		return (T) this;
	}

	/**
	 * The official names of the standard roles supported by the current
	 * management access control provider.
	 */
	@ModelNodeBinding(detypedName = "standard-role-names")
	public List<String> standardRoleNames() {
		return this.standardRoleNames;
	}

	/**
	 * The official names of the standard roles supported by the current
	 * management access control provider.
	 */
	@SuppressWarnings("unchecked")
	public T standardRoleNames(java.util.List<String> value) {
		Object oldValue = this.standardRoleNames;
		this.standardRoleNames = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("standardRoleNames", oldValue, value);
		return (T) this;
	}

	/**
	 * The official names of the standard roles supported by the current
	 * management access control provider.
	 */
	@SuppressWarnings("unchecked")
	public T standardRoleName(String value) {
		if (this.standardRoleNames == null) {
			this.standardRoleNames = new java.util.ArrayList<>();
		}
		this.standardRoleNames.add(value);
		return (T) this;
	}

	/**
	 * The official names of the standard roles supported by the current
	 * management access control provider.
	 */
	@SuppressWarnings("unchecked")
	public T standardRoleNames(String... args) {
		standardRoleNames(Arrays.asList(args));
		return (T) this;
	}
}