package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Defines a way in which remote connections can be made to the ActiveMQ server
 * over HTTP.
 */
@Address("/subsystem=messaging-activemq/server=*/http-acceptor=*")
@ResourceType("http-acceptor")
public class HTTPAcceptor<T extends HTTPAcceptor<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private String httpListener;
	private Map params;
	private Boolean upgradeLegacy;

	public HTTPAcceptor(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The Undertow's http-listener that handles HTTP upgrade requests.
	 */
	@ModelNodeBinding(detypedName = "http-listener")
	public String httpListener() {
		return this.httpListener;
	}

	/**
	 * The Undertow's http-listener that handles HTTP upgrade requests.
	 */
	@SuppressWarnings("unchecked")
	public T httpListener(java.lang.String value) {
		Object oldValue = this.httpListener;
		this.httpListener = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("httpListener", oldValue, value);
		return (T) this;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to
	 * configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to
	 * configure it.
	 */
	@SuppressWarnings("unchecked")
	public T params(java.util.Map value) {
		Object oldValue = this.params;
		this.params = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("params", oldValue, value);
		return (T) this;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to
	 * configure it.
	 */
	@SuppressWarnings("unchecked")
	public T param(java.lang.String key, java.lang.Object value) {
		if (this.params == null) {
			this.params = new java.util.HashMap<>();
		}
		this.params.put(key, value);
		return (T) this;
	}

	/**
	 * Also accepts to upgrade HTTP request from legacy (HornetQ) clients.
	 */
	@ModelNodeBinding(detypedName = "upgrade-legacy")
	public Boolean upgradeLegacy() {
		return this.upgradeLegacy;
	}

	/**
	 * Also accepts to upgrade HTTP request from legacy (HornetQ) clients.
	 */
	@SuppressWarnings("unchecked")
	public T upgradeLegacy(java.lang.Boolean value) {
		Object oldValue = this.upgradeLegacy;
		this.upgradeLegacy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("upgradeLegacy", oldValue, value);
		return (T) this;
	}
}