package org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.Arrays;

/**
 * Load metric definition
 */
@Address("/subsystem=modcluster/mod-cluster-config=configuration/dynamic-load-provider=configuration/load-metric=*")
@ResourceType("load-metric")
public class LoadMetric<T extends LoadMetric<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private Double capacity;
	private Map property;
	private Type type;
	private Integer weight;

	public LoadMetric(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum Type {
		CPU("cpu"), MEM("mem"), HEAP("heap"), SESSIONS("sessions"), RECEIVE_TRAFFIC(
				"receive-traffic"), SEND_TRAFFIC("send-traffic"), REQUESTS(
				"requests"), BUSYNESS("busyness");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Type(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * Capacity of the metric.
	 */
	@ModelNodeBinding(detypedName = "capacity")
	public Double capacity() {
		return this.capacity;
	}

	/**
	 * Capacity of the metric.
	 */
	@SuppressWarnings("unchecked")
	public T capacity(java.lang.Double value) {
		Object oldValue = this.capacity;
		this.capacity = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacity", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties for the metric.
	 */
	@ModelNodeBinding(detypedName = "property")
	public Map property() {
		return this.property;
	}

	/**
	 * Properties for the metric.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.util.Map value) {
		Object oldValue = this.property;
		this.property = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("property", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties for the metric.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String key, java.lang.Object value) {
		if (this.property == null) {
			this.property = new java.util.HashMap<>();
		}
		this.property.put(key, value);
		return (T) this;
	}

	/**
	 * Type of the metric
	 */
	@ModelNodeBinding(detypedName = "type")
	public Type type() {
		return this.type;
	}

	/**
	 * Type of the metric
	 */
	@SuppressWarnings("unchecked")
	public T type(Type value) {
		Object oldValue = this.type;
		this.type = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("type", oldValue, value);
		return (T) this;
	}

	/**
	 * Weight of the metric.
	 */
	@ModelNodeBinding(detypedName = "weight")
	public Integer weight() {
		return this.weight;
	}

	/**
	 * Weight of the metric.
	 */
	@SuppressWarnings("unchecked")
	public T weight(java.lang.Integer value) {
		Object oldValue = this.weight;
		this.weight = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("weight", oldValue, value);
		return (T) this;
	}
}