package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.undertow.configuration.Rewrite;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RewriteConsumer<T extends Rewrite<T>> {

	/**
	 * Configure a pre-constructed instance of Rewrite resource
	 * 
	 * @parameter Instance of Rewrite to configure
	 * @return nothing
	 */
	void accept(T value);

	default RewriteConsumer<T> andThen(RewriteConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}