package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Session cookie configuration
 */
@Address("/subsystem=undertow/servlet-container=*/setting=session-cookie")
@ResourceType("setting")
@Implicit
public class SessionCookieSetting<T extends SessionCookieSetting<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private String comment;
	private String domain;
	private Boolean httpOnly;
	private Integer maxAge;
	private String name;
	private Boolean secure;

	public SessionCookieSetting() {
		super();
		this.key = "session-cookie";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Cookie comment
	 */
	@ModelNodeBinding(detypedName = "comment")
	public String comment() {
		return this.comment;
	}

	/**
	 * Cookie comment
	 */
	@SuppressWarnings("unchecked")
	public T comment(java.lang.String value) {
		Object oldValue = this.comment;
		this.comment = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("comment", oldValue, value);
		return (T) this;
	}

	/**
	 * Cookie domain
	 */
	@ModelNodeBinding(detypedName = "domain")
	public String domain() {
		return this.domain;
	}

	/**
	 * Cookie domain
	 */
	@SuppressWarnings("unchecked")
	public T domain(java.lang.String value) {
		Object oldValue = this.domain;
		this.domain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("domain", oldValue, value);
		return (T) this;
	}

	/**
	 * Is cookie http-only
	 */
	@ModelNodeBinding(detypedName = "http-only")
	public Boolean httpOnly() {
		return this.httpOnly;
	}

	/**
	 * Is cookie http-only
	 */
	@SuppressWarnings("unchecked")
	public T httpOnly(java.lang.Boolean value) {
		Object oldValue = this.httpOnly;
		this.httpOnly = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("httpOnly", oldValue, value);
		return (T) this;
	}

	/**
	 * Max age of cookie
	 */
	@ModelNodeBinding(detypedName = "max-age")
	public Integer maxAge() {
		return this.maxAge;
	}

	/**
	 * Max age of cookie
	 */
	@SuppressWarnings("unchecked")
	public T maxAge(java.lang.Integer value) {
		Object oldValue = this.maxAge;
		this.maxAge = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxAge", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the cookie
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * Name of the cookie
	 */
	@SuppressWarnings("unchecked")
	public T name(java.lang.String value) {
		Object oldValue = this.name;
		this.name = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("name", oldValue, value);
		return (T) this;
	}

	/**
	 * Is cookie secure?
	 */
	@ModelNodeBinding(detypedName = "secure")
	public Boolean secure() {
		return this.secure;
	}

	/**
	 * Is cookie secure?
	 */
	@SuppressWarnings("unchecked")
	public T secure(java.lang.Boolean value) {
		Object oldValue = this.secure;
		this.secure = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("secure", oldValue, value);
		return (T) this;
	}
}