/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.management.access.AuditLogLogger;
import org.wildfly.swarm.config.management.access.AuditLogLoggerConsumer;
import org.wildfly.swarm.config.management.access.AuditLogLoggerSupplier;
import org.wildfly.swarm.config.management.access.FileHandler;
import org.wildfly.swarm.config.management.access.FileHandlerConsumer;
import org.wildfly.swarm.config.management.access.FileHandlerSupplier;
import org.wildfly.swarm.config.management.access.InMemoryHandler;
import org.wildfly.swarm.config.management.access.InMemoryHandlerConsumer;
import org.wildfly.swarm.config.management.access.InMemoryHandlerSupplier;
import org.wildfly.swarm.config.management.access.JsonFormatter;
import org.wildfly.swarm.config.management.access.JsonFormatterConsumer;
import org.wildfly.swarm.config.management.access.JsonFormatterSupplier;
import org.wildfly.swarm.config.management.access.PeriodicRotatingFileHandler;
import org.wildfly.swarm.config.management.access.PeriodicRotatingFileHandlerConsumer;
import org.wildfly.swarm.config.management.access.PeriodicRotatingFileHandlerSupplier;
import org.wildfly.swarm.config.management.access.SizeRotatingFileHandler;
import org.wildfly.swarm.config.management.access.SizeRotatingFileHandlerConsumer;
import org.wildfly.swarm.config.management.access.SizeRotatingFileHandlerSupplier;
import org.wildfly.swarm.config.management.access.SyslogHandler;
import org.wildfly.swarm.config.management.access.SyslogHandlerConsumer;
import org.wildfly.swarm.config.management.access.SyslogHandlerSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/core-service=management/access=audit")
@ResourceType(value="access")
@Implicit
public class AuditAccess<T extends AuditAccess<T>>
extends HashMap
implements Keyed {
    private String key = "audit";
    private PropertyChangeSupport pcs;
    private AuditAccessResources subresources = new AuditAccessResources();

    public AuditAccess() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public AuditAccessResources subresources() {
        return this.subresources;
    }

    public T periodicRotatingFileHandlers(List<PeriodicRotatingFileHandler> value) {
        this.subresources.periodicRotatingFileHandlers = value;
        return (T)this;
    }

    public T periodicRotatingFileHandler(PeriodicRotatingFileHandler value) {
        this.subresources.periodicRotatingFileHandlers.add(value);
        return (T)this;
    }

    public T periodicRotatingFileHandler(String childKey, PeriodicRotatingFileHandlerConsumer consumer) {
        PeriodicRotatingFileHandler child = new PeriodicRotatingFileHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.periodicRotatingFileHandler(child);
        return (T)this;
    }

    public T periodicRotatingFileHandler(String childKey) {
        this.periodicRotatingFileHandler(childKey, null);
        return (T)this;
    }

    public T periodicRotatingFileHandler(PeriodicRotatingFileHandlerSupplier supplier) {
        this.periodicRotatingFileHandler(supplier.get());
        return (T)this;
    }

    public T inMemoryHandlers(List<InMemoryHandler> value) {
        this.subresources.inMemoryHandlers = value;
        return (T)this;
    }

    public T inMemoryHandler(InMemoryHandler value) {
        this.subresources.inMemoryHandlers.add(value);
        return (T)this;
    }

    public T inMemoryHandler(String childKey, InMemoryHandlerConsumer consumer) {
        InMemoryHandler child = new InMemoryHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.inMemoryHandler(child);
        return (T)this;
    }

    public T inMemoryHandler(String childKey) {
        this.inMemoryHandler(childKey, null);
        return (T)this;
    }

    public T inMemoryHandler(InMemoryHandlerSupplier supplier) {
        this.inMemoryHandler(supplier.get());
        return (T)this;
    }

    public T jsonFormatters(List<JsonFormatter> value) {
        this.subresources.jsonFormatters = value;
        return (T)this;
    }

    public T jsonFormatter(JsonFormatter value) {
        this.subresources.jsonFormatters.add(value);
        return (T)this;
    }

    public T jsonFormatter(String childKey, JsonFormatterConsumer consumer) {
        JsonFormatter child = new JsonFormatter(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.jsonFormatter(child);
        return (T)this;
    }

    public T jsonFormatter(String childKey) {
        this.jsonFormatter(childKey, null);
        return (T)this;
    }

    public T jsonFormatter(JsonFormatterSupplier supplier) {
        this.jsonFormatter(supplier.get());
        return (T)this;
    }

    public T fileHandlers(List<FileHandler> value) {
        this.subresources.fileHandlers = value;
        return (T)this;
    }

    public T fileHandler(FileHandler value) {
        this.subresources.fileHandlers.add(value);
        return (T)this;
    }

    public T fileHandler(String childKey, FileHandlerConsumer consumer) {
        FileHandler child = new FileHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.fileHandler(child);
        return (T)this;
    }

    public T fileHandler(String childKey) {
        this.fileHandler(childKey, null);
        return (T)this;
    }

    public T fileHandler(FileHandlerSupplier supplier) {
        this.fileHandler(supplier.get());
        return (T)this;
    }

    public T sizeRotatingFileHandlers(List<SizeRotatingFileHandler> value) {
        this.subresources.sizeRotatingFileHandlers = value;
        return (T)this;
    }

    public T sizeRotatingFileHandler(SizeRotatingFileHandler value) {
        this.subresources.sizeRotatingFileHandlers.add(value);
        return (T)this;
    }

    public T sizeRotatingFileHandler(String childKey, SizeRotatingFileHandlerConsumer consumer) {
        SizeRotatingFileHandler child = new SizeRotatingFileHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.sizeRotatingFileHandler(child);
        return (T)this;
    }

    public T sizeRotatingFileHandler(String childKey) {
        this.sizeRotatingFileHandler(childKey, null);
        return (T)this;
    }

    public T sizeRotatingFileHandler(SizeRotatingFileHandlerSupplier supplier) {
        this.sizeRotatingFileHandler(supplier.get());
        return (T)this;
    }

    public T syslogHandlers(List<SyslogHandler> value) {
        this.subresources.syslogHandlers = value;
        return (T)this;
    }

    public T syslogHandler(SyslogHandler value) {
        this.subresources.syslogHandlers.add(value);
        return (T)this;
    }

    public T syslogHandler(String childKey, SyslogHandlerConsumer consumer) {
        SyslogHandler child = new SyslogHandler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.syslogHandler(child);
        return (T)this;
    }

    public T syslogHandler(String childKey) {
        this.syslogHandler(childKey, null);
        return (T)this;
    }

    public T syslogHandler(SyslogHandlerSupplier supplier) {
        this.syslogHandler(supplier.get());
        return (T)this;
    }

    public T auditLogLogger(AuditLogLogger value) {
        this.subresources.auditLogLogger = value;
        return (T)this;
    }

    public T auditLogLogger(AuditLogLoggerConsumer consumer) {
        AuditLogLogger child = new AuditLogLogger();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.auditLogLogger = child;
        return (T)this;
    }

    public T auditLogLogger() {
        AuditLogLogger child = new AuditLogLogger();
        this.subresources.auditLogLogger = child;
        return (T)this;
    }

    public T auditLogLogger(AuditLogLoggerSupplier supplier) {
        this.subresources.auditLogLogger = supplier.get();
        return (T)this;
    }

    public static class AuditAccessResources {
        @SubresourceInfo(value="periodicRotatingFileHandler")
        private List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers = new ArrayList<PeriodicRotatingFileHandler>();
        @SubresourceInfo(value="inMemoryHandler")
        private List<InMemoryHandler> inMemoryHandlers = new ArrayList<InMemoryHandler>();
        @SubresourceInfo(value="jsonFormatter")
        private List<JsonFormatter> jsonFormatters = new ArrayList<JsonFormatter>();
        @SubresourceInfo(value="fileHandler")
        private List<FileHandler> fileHandlers = new ArrayList<FileHandler>();
        @SubresourceInfo(value="sizeRotatingFileHandler")
        private List<SizeRotatingFileHandler> sizeRotatingFileHandlers = new ArrayList<SizeRotatingFileHandler>();
        @SubresourceInfo(value="syslogHandler")
        private List<SyslogHandler> syslogHandlers = new ArrayList<SyslogHandler>();
        private AuditLogLogger auditLogLogger;

        @Subresource
        public List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers() {
            return this.periodicRotatingFileHandlers;
        }

        public PeriodicRotatingFileHandler periodicRotatingFileHandler(String key) {
            return this.periodicRotatingFileHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<InMemoryHandler> inMemoryHandlers() {
            return this.inMemoryHandlers;
        }

        public InMemoryHandler inMemoryHandler(String key) {
            return this.inMemoryHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<JsonFormatter> jsonFormatters() {
            return this.jsonFormatters;
        }

        public JsonFormatter jsonFormatter(String key) {
            return this.jsonFormatters.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<FileHandler> fileHandlers() {
            return this.fileHandlers;
        }

        public FileHandler fileHandler(String key) {
            return this.fileHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<SizeRotatingFileHandler> sizeRotatingFileHandlers() {
            return this.sizeRotatingFileHandlers;
        }

        public SizeRotatingFileHandler sizeRotatingFileHandler(String key) {
            return this.sizeRotatingFileHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<SyslogHandler> syslogHandlers() {
            return this.syslogHandlers;
        }

        public SyslogHandler syslogHandler(String key) {
            return this.syslogHandlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public AuditLogLogger auditLogLogger() {
            return this.auditLogLogger;
        }
    }
}

