package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.NoneTransport;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface NoneTransportConsumer<T extends NoneTransport<T>> {

	/**
	 * Configure a pre-constructed instance of NoneTransport resource
	 * 
	 * @parameter Instance of NoneTransport to configure
	 * @return nothing
	 */
	void accept(T value);

	default NoneTransportConsumer<T> andThen(NoneTransportConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}