package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;

/**
 * Configuration of the server's HTTP management interface
 */
@Address("/core-service=management/management-interface=http-interface")
@ResourceType("management-interface")
@Implicit
public class HTTPInterfaceManagementInterface<T extends HTTPInterfaceManagementInterface<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private List<String> allowedOrigins;
	private Boolean consoleEnabled;
	private Boolean httpUpgradeEnabled;
	private String saslProtocol;
	private String secureSocketBinding;
	private String securityRealm;
	private String serverName;
	private String socketBinding;

	public HTTPInterfaceManagementInterface() {
		super();
		this.key = "http-interface";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Comma separated list of trusted Origins for sending Cross-Origin Resource
	 * Sharing requests on the management API once the user is authenticated.
	 */
	@ModelNodeBinding(detypedName = "allowed-origins")
	public List<String> allowedOrigins() {
		return this.allowedOrigins;
	}

	/**
	 * Comma separated list of trusted Origins for sending Cross-Origin Resource
	 * Sharing requests on the management API once the user is authenticated.
	 */
	@SuppressWarnings("unchecked")
	public T allowedOrigins(java.util.List<String> value) {
		Object oldValue = this.allowedOrigins;
		this.allowedOrigins = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowedOrigins", oldValue, value);
		return (T) this;
	}

	/**
	 * Comma separated list of trusted Origins for sending Cross-Origin Resource
	 * Sharing requests on the management API once the user is authenticated.
	 */
	@SuppressWarnings("unchecked")
	public T allowedOrigin(String value) {
		if (this.allowedOrigins == null) {
			this.allowedOrigins = new java.util.ArrayList<>();
		}
		this.allowedOrigins.add(value);
		return (T) this;
	}

	/**
	 * Comma separated list of trusted Origins for sending Cross-Origin Resource
	 * Sharing requests on the management API once the user is authenticated.
	 */
	@SuppressWarnings("unchecked")
	public T allowedOrigins(String... args) {
		allowedOrigins(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * Flag that indicates admin console is enabled
	 */
	@ModelNodeBinding(detypedName = "console-enabled")
	public Boolean consoleEnabled() {
		return this.consoleEnabled;
	}

	/**
	 * Flag that indicates admin console is enabled
	 */
	@SuppressWarnings("unchecked")
	public T consoleEnabled(java.lang.Boolean value) {
		Object oldValue = this.consoleEnabled;
		this.consoleEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("consoleEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Flag that indicates HTTP Upgrade is enabled, which allows HTTP requests
	 * to be upgraded to native remoting connections
	 */
	@ModelNodeBinding(detypedName = "http-upgrade-enabled")
	public Boolean httpUpgradeEnabled() {
		return this.httpUpgradeEnabled;
	}

	/**
	 * Flag that indicates HTTP Upgrade is enabled, which allows HTTP requests
	 * to be upgraded to native remoting connections
	 */
	@SuppressWarnings("unchecked")
	public T httpUpgradeEnabled(java.lang.Boolean value) {
		Object oldValue = this.httpUpgradeEnabled;
		this.httpUpgradeEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("httpUpgradeEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the protocol to be passed to the SASL mechanisms used for
	 * authentication.
	 */
	@ModelNodeBinding(detypedName = "sasl-protocol")
	public String saslProtocol() {
		return this.saslProtocol;
	}

	/**
	 * The name of the protocol to be passed to the SASL mechanisms used for
	 * authentication.
	 */
	@SuppressWarnings("unchecked")
	public T saslProtocol(java.lang.String value) {
		Object oldValue = this.saslProtocol;
		this.saslProtocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("saslProtocol", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the socket binding configuration to use for the HTTPS
	 * management interface's socket.
	 */
	@ModelNodeBinding(detypedName = "secure-socket-binding")
	public String secureSocketBinding() {
		return this.secureSocketBinding;
	}

	/**
	 * The name of the socket binding configuration to use for the HTTPS
	 * management interface's socket.
	 */
	@SuppressWarnings("unchecked")
	public T secureSocketBinding(java.lang.String value) {
		Object oldValue = this.secureSocketBinding;
		this.secureSocketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("secureSocketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * The security realm to use for the HTTP management interface.
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The security realm to use for the HTTP management interface.
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(java.lang.String value) {
		Object oldValue = this.securityRealm;
		this.securityRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityRealm", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the server used in the initial Remoting exchange and within
	 * the SASL mechanisms.
	 */
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The name of the server used in the initial Remoting exchange and within
	 * the SASL mechanisms.
	 */
	@SuppressWarnings("unchecked")
	public T serverName(java.lang.String value) {
		Object oldValue = this.serverName;
		this.serverName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverName", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the socket binding configuration to use for the HTTP
	 * management interface's socket.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The name of the socket binding configuration to use for the HTTP
	 * management interface's socket.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(java.lang.String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}
}