package org.wildfly.swarm.config.singleton.singleton_policy;

import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;

/**
 * A random election policy
 */
@Address("/subsystem=singleton/singleton-policy=*/election-policy=random")
@ResourceType("election-policy")
@Implicit
public class RandomElectionPolicy<T extends RandomElectionPolicy<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private List<String> namePreferences;
	private List<String> socketBindingPreferences;

	public RandomElectionPolicy() {
		super();
		this.key = "random";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The list of preferred node names
	 */
	@ModelNodeBinding(detypedName = "name-preferences")
	public List<String> namePreferences() {
		return this.namePreferences;
	}

	/**
	 * The list of preferred node names
	 */
	@SuppressWarnings("unchecked")
	public T namePreferences(java.util.List<String> value) {
		Object oldValue = this.namePreferences;
		this.namePreferences = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("namePreferences", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of preferred node names
	 */
	@SuppressWarnings("unchecked")
	public T namePreference(String value) {
		if (this.namePreferences == null) {
			this.namePreferences = new java.util.ArrayList<>();
		}
		this.namePreferences.add(value);
		return (T) this;
	}

	/**
	 * The list of preferred node names
	 */
	@SuppressWarnings("unchecked")
	public T namePreferences(String... args) {
		namePreferences(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The list of preferred node socket bindings
	 */
	@ModelNodeBinding(detypedName = "socket-binding-preferences")
	public List<String> socketBindingPreferences() {
		return this.socketBindingPreferences;
	}

	/**
	 * The list of preferred node socket bindings
	 */
	@SuppressWarnings("unchecked")
	public T socketBindingPreferences(java.util.List<String> value) {
		Object oldValue = this.socketBindingPreferences;
		this.socketBindingPreferences = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBindingPreferences", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The list of preferred node socket bindings
	 */
	@SuppressWarnings("unchecked")
	public T socketBindingPreference(String value) {
		if (this.socketBindingPreferences == null) {
			this.socketBindingPreferences = new java.util.ArrayList<>();
		}
		this.socketBindingPreferences.add(value);
		return (T) this;
	}

	/**
	 * The list of preferred node socket bindings
	 */
	@SuppressWarnings("unchecked")
	public T socketBindingPreferences(String... args) {
		socketBindingPreferences(Arrays.asList(args));
		return (T) this;
	}
}